/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import javax.management.ObjectName;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache;
import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.stats.AbstractStatisticalItem;
import org.jboss.varia.stats.CacheListenerMBean;
import org.jboss.varia.stats.StatisticalItem;

public class CacheListener
extends ServiceMBeanSupport
implements Cache.Listener,
CacheListenerMBean {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$varia$stats$CacheListener == null ? (class$org$jboss$varia$stats$CacheListener = CacheListener.class$("org.jboss.varia.stats.CacheListener")) : class$org$jboss$varia$stats$CacheListener));
    private ObjectName statsCollector;
    private ObjectName cacheName;
    private String tableName;
    static /* synthetic */ Class class$org$jboss$varia$stats$CacheListener;
    static /* synthetic */ Class class$org$jboss$ejb$plugins$cmp$jdbc2$schema$Cache$Listener;
    static /* synthetic */ Class class$org$jboss$varia$stats$StatisticalItem;

    public ObjectName getStatsCollector() {
        return this.statsCollector;
    }

    public void setStatsCollector(ObjectName statsCollector) {
        this.statsCollector = statsCollector;
    }

    public ObjectName getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(ObjectName cacheName) {
        this.cacheName = cacheName;
    }

    public void startService() throws Exception {
        this.tableName = this.cacheName.getKeyProperty("table");
        this.getServer().invoke(this.cacheName, "registerListener", new Object[]{this}, new String[]{(class$org$jboss$ejb$plugins$cmp$jdbc2$schema$Cache$Listener == null ? (class$org$jboss$ejb$plugins$cmp$jdbc2$schema$Cache$Listener = CacheListener.class$("org.jboss.ejb.plugins.cmp.jdbc2.schema.Cache$Listener")) : class$org$jboss$ejb$plugins$cmp$jdbc2$schema$Cache$Listener).getName()});
    }

    public void contention(int partitionIndex, long time) {
        try {
            ContentionStats item = new ContentionStats(this.tableName, partitionIndex, time);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{(class$org$jboss$varia$stats$StatisticalItem == null ? (class$org$jboss$varia$stats$StatisticalItem = CacheListener.class$("org.jboss.varia.stats.StatisticalItem")) : class$org$jboss$varia$stats$StatisticalItem).getName()});
        }
        catch (Exception e) {
            log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    public void eviction(int partitionIndex, Object pk, int size) {
        try {
            EvictionStats item = new EvictionStats(this.tableName, partitionIndex, pk);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{(class$org$jboss$varia$stats$StatisticalItem == null ? (class$org$jboss$varia$stats$StatisticalItem = CacheListener.class$("org.jboss.varia.stats.StatisticalItem")) : class$org$jboss$varia$stats$StatisticalItem).getName()});
        }
        catch (Exception e) {
            log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    public void hit(int partitionIndex) {
        try {
            HitStats item = new HitStats(this.tableName, partitionIndex);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{(class$org$jboss$varia$stats$StatisticalItem == null ? (class$org$jboss$varia$stats$StatisticalItem = CacheListener.class$("org.jboss.varia.stats.StatisticalItem")) : class$org$jboss$varia$stats$StatisticalItem).getName()});
        }
        catch (Exception e) {
            log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    public void miss(int partitionIndex) {
        try {
            MissStats item = new MissStats(this.tableName, partitionIndex);
            this.server.invoke(this.statsCollector, "addStatisticalItem", new Object[]{item}, new String[]{(class$org$jboss$varia$stats$StatisticalItem == null ? (class$org$jboss$varia$stats$StatisticalItem = CacheListener.class$("org.jboss.varia.stats.StatisticalItem")) : class$org$jboss$varia$stats$StatisticalItem).getName()});
        }
        catch (Exception e) {
            log.error((Object)"Failed to add invocation.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EvictionStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Cache Eviction Statistics Per Transaction";
        private final String tableName;
        private final Object pk;

        public EvictionStats(String tableName, int partitionIndex, Object pk) {
            super(NAME);
            this.value = tableName;
            this.tableName = tableName;
            this.pk = pk;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Object getPk() {
            return this.pk;
        }
    }

    public static class ContentionStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Cache Contention Statistics Per Transaction";
        private long maxContentionTime;
        private long contentionTimeTotal;

        public ContentionStats(String name, int partitionIndex, long ms) {
            super(NAME);
            this.value = name;
            this.contentionTimeTotal = this.maxContentionTime = ms;
        }

        public void merge(StatisticalItem item) {
            super.merge(item);
            ContentionStats cs = (ContentionStats)item;
            if (cs.maxContentionTime > this.maxContentionTime) {
                this.maxContentionTime = cs.maxContentionTime;
            }
            this.contentionTimeTotal += cs.contentionTimeTotal;
        }

        public long getContentionTimeTotal() {
            return this.contentionTimeTotal;
        }

        public long getMaxContentionTime() {
            return this.maxContentionTime;
        }
    }

    public static class MissStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Cache Misses Per Transaction";

        public MissStats(String name, int partitionIndex) {
            super(NAME);
            this.value = name;
        }
    }

    public static class HitStats
    extends AbstractStatisticalItem {
        public static final String NAME = "Cache Hits Per Transaction";
        private final String tableName;
        private final int partitionIndex;

        public HitStats(String name, int partitionIndex) {
            super(NAME);
            this.value = name + partitionIndex;
            this.tableName = name;
            this.partitionIndex = partitionIndex;
        }

        public String getTableName() {
            return this.tableName;
        }

        public int getPartitionIndex() {
            return this.partitionIndex;
        }
    }
}

