/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.encoding.ser;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.encoding.ser.SimpleSerializer;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.wsdl.fromJava.Types;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class EnumSerializer
extends SimpleSerializer {
    private static Logger log = Logger.getLogger((String)EnumSerializer.class.getName());
    private Method toStringMethod = null;

    public EnumSerializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        context.startElement(name, attributes);
        context.writeString(this.getValueAsString(value, context));
        context.endElement();
    }

    public String getValueAsString(Object value, SerializationContext context) {
        try {
            if (this.toStringMethod == null) {
                this.toStringMethod = this.javaType.getMethod("toString", null);
            }
            return (String)this.toStringMethod.invoke(value, null);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage("exception00"), (Throwable)e);
            return null;
        }
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return types.writeEnumType(this.xmlType, javaType);
    }
}

