/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.ConnectException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.transport.socket.ServerAddress;

public class SocketClientInvoker
extends RemoteClientInvoker {
    private InetAddress addr;
    private int port;
    public static final String TCP_NODELAY_FLAG = "enableTcpNoDelay";
    public static final String MAX_POOL_SIZE_FLAG = "clientMaxPoolSize";
    public static final String SO_TIMEOUT_FLAG = "socketTimeout";
    public static final int SO_TIMEOUT_DEFAULT = 60000;
    public static final boolean TCP_NODELAY_DEFAULT = false;
    public static long getSocketTime = 0L;
    public static long readTime = 0L;
    public static long writeTime = 0L;
    public static long serializeTime = 0L;
    public static long deserializeTime = 0L;
    protected boolean enableTcpNoDelay = false;
    protected int timeout = 60000;
    public static final int MAX_RETRIES = 10;
    public static long usedPooled = 0L;
    protected int numberOfRetries = 10;
    protected LinkedList pool = null;
    protected ServerAddress address;
    protected static HashMap connectionPools = new HashMap();
    protected int maxPoolSize = 10;

    public SocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected void setup() throws Exception {
        this.addr = InetAddress.getByName(this.locator.getHost());
        this.port = this.locator.getPort();
        this.configureParameters();
        this.address = new ServerAddress(this.addr.getHostAddress(), this.port, this.enableTcpNoDelay, this.timeout);
    }

    private void configureParameters() {
        Map params = this.locator.getParameters();
        if (params != null) {
            Object val = params.get(TCP_NODELAY_FLAG);
            if (val != null) {
                try {
                    boolean bVal;
                    this.enableTcpNoDelay = bVal = Boolean.valueOf((String)val).booleanValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::enableTcpNoDelay to: " + this.enableTcpNoDelay));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert enableTcpNoDelay value of " + val + " to a boolean value."));
                }
            }
            if ((val = params.get(MAX_POOL_SIZE_FLAG)) != null) {
                try {
                    int nVal;
                    this.maxPoolSize = nVal = Integer.valueOf((String)val).intValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::maxPoolSize to: " + this.maxPoolSize));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert clientMaxPoolSize value of " + val + " to a int value."));
                }
            }
            if ((val = params.get(SO_TIMEOUT_FLAG)) != null) {
                try {
                    int nVal;
                    this.timeout = nVal = Integer.valueOf((String)val).intValue();
                    this.log.debug((Object)("Setting SocketClientInvoker::timeout to: " + this.timeout));
                }
                catch (Exception e) {
                    this.log.warn((Object)("Could not convert socketTimeout value of " + val + " to a int value."));
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }

    protected synchronized void handleConnect() throws ConnectionFailedException {
        this.initPool();
    }

    protected synchronized void handleDisconnect() {
        SocketClientInvoker.clearPools();
    }

    protected String getDefaultDataType() {
        return "serializable";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException, ClassNotFoundException {
        Object response = null;
        long start = System.currentTimeMillis();
        ClientSocket socket = null;
        try {
            socket = this.getConnection();
        }
        catch (Exception e) {
            throw new CannotConnectException("Can not get connection to server.  Problem establishing socket connection.", e);
        }
        long end = System.currentTimeMillis() - start;
        getSocketTime += end;
        try {
            marshaller.write(invocation, socket.oout);
            end = System.currentTimeMillis() - start;
            writeTime += end;
            start = System.currentTimeMillis();
            response = unmarshaller.read(socket.oin, null);
            end = System.currentTimeMillis() - start;
            readTime += end;
        }
        catch (Exception ex) {
            try {
                socket.socket.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            this.log.error((Object)"Got marshalling exception, exiting", (Throwable)ex);
            if (ex instanceof ClassNotFoundException) {
                this.log.error((Object)"Error loading classes from remote call result.", (Throwable)ex);
                throw (ClassNotFoundException)ex;
            }
            throw new ConnectException("Failed to communicate.  Problem during marshalling/unmarshalling", ex);
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (this.pool.size() < this.maxPoolSize) {
                this.pool.add(socket);
            } else {
                try {
                    socket.socket.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response: " + response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPool(ServerAddress sa) {
        try {
            LinkedList thepool = (LinkedList)connectionPools.get(sa);
            if (thepool == null) {
                return;
            }
            LinkedList linkedList = thepool;
            synchronized (linkedList) {
                int size = thepool.size();
                for (int i = 0; i < size; ++i) {
                    ClientSocket socket = (ClientSocket)thepool.removeFirst();
                    try {
                        socket.socket.close();
                        socket.socket = null;
                        continue;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearPools() {
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            Iterator it = connectionPools.keySet().iterator();
            while (it.hasNext()) {
                ServerAddress sa = (ServerAddress)it.next();
                SocketClientInvoker.clearPool(sa);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPool() {
        HashMap hashMap = connectionPools;
        synchronized (hashMap) {
            this.pool = (LinkedList)connectionPools.get(this.address);
            if (this.pool == null) {
                this.pool = new LinkedList();
                connectionPools.put(this.address, this.pool);
            }
        }
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries < 1 ? 10 : numberOfRetries;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClientSocket getConnection() throws Exception {
        Object failed = null;
        Socket socket = null;
        for (int i = 0; i < this.numberOfRetries; ++i) {
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                ClientSocket pooled;
                if (this.pool.size() > 0 && (pooled = this.getPooledConnection()) != null) {
                    ++usedPooled;
                    return pooled;
                }
            }
            try {
                socket = new Socket(this.address.address, this.address.port);
                break;
            }
            catch (Exception ex) {
                if (i + 1 >= 10) {
                    throw ex;
                }
                Thread.sleep(1L);
                continue;
            }
        }
        socket.setTcpNoDelay(this.address.enableTcpNoDelay);
        return new ClientSocket(socket, this.address.timeout);
    }

    protected ClientSocket getPooledConnection() {
        ClientSocket socket = null;
        while (this.pool.size() > 0) {
            socket = (ClientSocket)this.pool.removeFirst();
            try {
                boolean ACK = true;
                socket.oout.reset();
                socket.oout.writeByte(1);
                socket.oout.flush();
                socket.oin.readByte();
                return socket;
            }
            catch (Exception ex) {
                try {
                    socket.socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public String getServerHostName() throws Exception {
        return this.address.address;
    }

    protected static class ClientSocket {
        public BufferedOutputStream out;
        public BufferedInputStream in;
        public ObjectOutputStream oout;
        public ObjectInputStream oin;
        public Socket socket;
        public int timeout;

        public ClientSocket(Socket socket, int timeout) throws Exception {
            this.socket = socket;
            socket.setSoTimeout(timeout);
            this.timeout = timeout;
            this.out = new BufferedOutputStream(socket.getOutputStream());
            this.in = new BufferedInputStream(socket.getInputStream());
            this.oout = new ObjectOutputStream(this.out);
            this.oin = new ObjectInputStreamWithClassLoader(this.in, null);
        }

        protected void finalize() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

