/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jboss.logging.Logger;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public class HTTPClientInvoker
extends RemoteClientInvoker {
    protected final Logger log = Logger.getLogger(this.getClass());

    public HTTPClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        String targetURL = this.getLocator().getOriginalURI();
        Object httpResponse = this.useHttpURLConnection(targetURL, invocation, metadata, marshaller, unmarshaller);
        return httpResponse;
    }

    private Object useHttpURLConnection(String url, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) {
        Object result = null;
        try {
            URL externalURL = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)externalURL.openConnection();
            boolean isPost = true;
            if (metadata != null) {
                Map header;
                String type = (String)metadata.get("TYPE");
                if (type != null && type.equals("GET")) {
                    isPost = false;
                }
                if ((header = (Map)metadata.get("HEADER")) != null) {
                    Set keys = header.keySet();
                    Iterator itr = keys.iterator();
                    while (itr.hasNext()) {
                        String key = (String)itr.next();
                        String value = (String)header.get(key);
                        this.log.debug((Object)("Setting request header with " + key + " : " + value));
                        conn.setRequestProperty(key, value);
                    }
                }
            }
            if (isPost) {
                String soapAction;
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                if (metadata != null && (soapAction = (String)metadata.get("SOAPAction")) != null) {
                    conn.setRequestProperty("SOAPAction", soapAction);
                }
            } else {
                throw new Exception("HTTP GET opperation not currently supported.");
            }
            OutputStream stream = conn.getOutputStream();
            marshaller.write(invocation, stream);
            InputStream is = conn.getInputStream();
            Map<String, List<String>> headers = conn.getHeaderFields();
            result = unmarshaller.read(is, headers);
        }
        catch (Exception e) {
            this.log.debug((Object)"Error invoking http client invoker.", (Throwable)e);
            throw new CannotConnectException("Can not connect http client invoker.", e);
        }
        return result;
    }

    private Object useApacheHttpClient(String url, Object invocation, Marshaller marshaller) throws IOException {
        PostMethod post = new PostMethod(url);
        post.setRequestHeader("Content-type", "application/soap+xml");
        String body = (String)invocation;
        post.setRequestContentLength(body.length());
        post.setRequestBody(body);
        HttpClient client = new HttpClient();
        int status = client.executeMethod((HttpMethod)post);
        return post.getResponseBodyAsString();
    }

    protected void handleConnect() throws ConnectionFailedException {
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "http";
    }
}

