/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.MarshallLoaderFactory;
import org.jboss.remoting.transport.ConnectorMBean;
import org.jboss.remoting.transport.PortUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Connector
implements MBeanRegistration,
ConnectorMBean {
    protected ServerInvoker invoker;
    private String locatorURI;
    private Element xml;
    private InvokerLocator locator;
    private MBeanServer server;
    private Connector marshallerLoaderConnector = null;
    private boolean isMarshallerLoader = false;
    private boolean isStarted = false;
    protected final Logger log = Logger.getLogger(this.getClass());

    public Connector() {
    }

    protected Connector(boolean isMarshallerConnector) {
        this();
        this.isMarshallerLoader = isMarshallerConnector;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            HashMap invokerConfig = new HashMap();
            if (this.locatorURI == null && this.xml != null) {
                this.getInvokerConfig(invokerConfig);
            }
            if (this.locatorURI == null) {
                throw new IllegalStateException("Connector not configured with LocatorURI.");
            }
            this.locator = new InvokerLocator(this.locatorURI);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            if (this.invoker == null) {
                this.invoker = InvokerRegistry.createServerInvoker(this.locator, invokerConfig);
                this.locator = this.invoker.getLocator();
                if (this.server != null) {
                    try {
                        this.server.registerMBean(this.invoker, new ObjectName(this.invoker.getMBeanObjectName()));
                        this.invoker.setMBeanServer(this.server);
                    }
                    catch (Throwable e) {
                        this.log.warn((Object)("Error registering invoker " + this.invoker + " with MBeanServer."), e);
                    }
                }
            }
            if (!this.isMarshallerLoader) {
                if (this.marshallerLoaderConnector == null) {
                    this.marshallerLoaderConnector = this.createMarshallerLoader(this.locator);
                }
                if (this.marshallerLoaderConnector != null && !this.marshallerLoaderConnector.isStarted()) {
                    this.marshallerLoaderConnector.start();
                }
            }
            this.configureHandlers(cl);
            if (!this.invoker.isStarted()) {
                try {
                    this.invoker.start();
                }
                catch (Exception e) {
                    if (this.marshallerLoaderConnector != null) {
                        this.marshallerLoaderConnector.stop();
                    }
                    this.log.error((Object)"Error starting connector.", (Throwable)e);
                    throw e;
                }
            }
            this.isStarted = true;
        }
    }

    private Connector createMarshallerLoader(InvokerLocator locator) {
        MarshalFactory.getMarshaller(locator, this.getClass().getClassLoader());
        Connector marshallerLoader = null;
        InvokerLocator loaderLocator = MarshallLoaderFactory.convertLocator(locator);
        if (loaderLocator != null) {
            marshallerLoader = MarshallLoaderFactory.createMarshallLoader(loaderLocator);
        }
        return marshallerLoader;
    }

    private void getInvokerConfig(Map invokerConfig) {
        try {
            NodeList invokerNodes = this.xml.getElementsByTagName("invoker");
            if (invokerNodes != null && invokerNodes.getLength() >= 1) {
                Node invokerNode = invokerNodes.item(0);
                NamedNodeMap attributes = invokerNode.getAttributes();
                Node transportNode = attributes.getNamedItem("transport");
                if (transportNode != null) {
                    int port;
                    String host;
                    String transport = transportNode.getNodeValue();
                    if (invokerNodes.getLength() > 1) {
                        this.log.warn((Object)("Found more than one invokers defined in configuration.  Will only be using the first one - " + transport));
                    }
                    HashMap<String, String> paramConfig = new HashMap<String, String>();
                    NodeList invokerAttributes = invokerNode.getChildNodes();
                    int len = invokerAttributes.getLength();
                    for (int x = 0; x < len; ++x) {
                        Node attr = invokerAttributes.item(x);
                        if (!"attribute".equals(attr.getNodeName())) continue;
                        String name = attr.getAttributes().getNamedItem("name").getNodeValue();
                        String value = attr.getFirstChild().getNodeValue();
                        invokerConfig.put(name, value);
                        Node isParamAttribute = attr.getAttributes().getNamedItem("isParam");
                        if (isParamAttribute == null || !Boolean.valueOf(isParamAttribute.getNodeValue()).booleanValue()) continue;
                        paramConfig.put(name, value);
                    }
                    String clientConnectAddress = (String)invokerConfig.get("clientConnectAddress");
                    String clientConnectPort = (String)invokerConfig.get("clientConnectPort");
                    String serverBindAddress = (String)invokerConfig.get("serverBindAddress");
                    String serverBindPort = (String)invokerConfig.get("serverBindPort");
                    String string = clientConnectAddress != null ? clientConnectAddress : (host = serverBindAddress != null ? serverBindAddress : InetAddress.getLocalHost().getHostAddress());
                    int n = clientConnectPort != null ? Integer.parseInt(clientConnectPort) : (port = serverBindPort != null ? Integer.parseInt(serverBindPort) : PortUtil.findFreePort());
                    if ("0.0.0.0".equals(host)) {
                        host = InetAddress.getLocalHost().getHostAddress();
                    }
                    String tempURI = transport + "://" + host + ":" + port;
                    if (paramConfig.size() > 0) {
                        Object value;
                        Object name;
                        tempURI = tempURI + "/?";
                        Iterator keyItr = paramConfig.keySet().iterator();
                        if (keyItr.hasNext()) {
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                        while (keyItr.hasNext()) {
                            tempURI = tempURI + "&";
                            name = keyItr.next();
                            value = paramConfig.get(name);
                            tempURI = tempURI + name + "=" + value;
                        }
                    }
                    this.locatorURI = tempURI;
                } else {
                    this.log.error((Object)"Invoker element within Configuration attribute does not contain a transport attribute.");
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error configuring invoker for connector.", (Throwable)e);
            throw new IllegalStateException("Error configuring invoker for connector.  Can not continue without invoker.");
        }
    }

    private void configureHandlers(ClassLoader cl) throws Exception {
        if (this.xml != null) {
            NodeList handlersNodes = this.xml.getElementsByTagName("handler");
            if (handlersNodes == null || handlersNodes.getLength() <= 0) {
                throw new IllegalArgumentException("required 'handler' element not found");
            }
            int len = handlersNodes.getLength();
            for (int c = 0; c < len; ++c) {
                Node node = handlersNodes.item(c);
                Node subNode = node.getAttributes().getNamedItem("subsystem");
                if (subNode == null) {
                    throw new IllegalArgumentException("Required 'subsystem' attribute on 'handler' element");
                }
                String handlerClass = node.getFirstChild().getNodeValue();
                boolean isObjName = false;
                ServerInvocationHandler handler = null;
                try {
                    ObjectName objName = new ObjectName(handlerClass);
                    handler = this.createHandlerProxy(objName);
                    isObjName = true;
                }
                catch (MalformedObjectNameException e) {
                    this.log.debug((Object)"Handler supplied is not an object name.");
                }
                if (!isObjName) {
                    handler = (ServerInvocationHandler)cl.loadClass(handlerClass).newInstance();
                }
                StringTokenizer tok = new StringTokenizer(subNode.getNodeValue(), ",");
                while (tok.hasMoreTokens()) {
                    String subsystem = tok.nextToken();
                    this.addInvocationHandler(subsystem, handler);
                }
            }
        }
    }

    private ServerInvocationHandler createHandlerProxy(ObjectName objName) {
        if (this.server == null) {
            throw new RuntimeException("Can not register MBean invocation handler as the Connector has not been registered with a MBeanServer.");
        }
        ServerInvocationHandler handler = (ServerInvocationHandler)MBeanServerInvocationHandler.newProxyInstance(this.server, objName, ServerInvocationHandler.class, false);
        return handler;
    }

    public void stop() {
        if (this.isStarted) {
            if (this.invoker != null) {
                this.invoker.stop();
                this.invoker = null;
            }
            if (this.marshallerLoaderConnector != null && this.marshallerLoaderConnector.isStarted) {
                this.marshallerLoaderConnector.stop();
                this.marshallerLoaderConnector = null;
            }
            this.isStarted = false;
        }
    }

    public void create() throws Exception {
    }

    public void destroy() {
        if (this.invoker != null) {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setInvokerLocator(String locator) throws Exception {
        this.locatorURI = locator;
    }

    public String getInvokerLocator() throws Exception {
        return this.locatorURI;
    }

    public void setConfiguration(Element xml) throws Exception {
        this.xml = xml;
    }

    public Element getConfiguration() {
        return this.xml;
    }

    public void addInvocationHandler(String subsystem, ObjectName handlerObjectName) throws Exception {
        ServerInvocationHandler invocationHandler = this.createHandlerProxy(handlerObjectName);
        this.addInvocationHandler(subsystem, invocationHandler);
    }

    public void addInvocationHandler(String subsystem, ServerInvocationHandler handler) throws Exception {
        if (this.invoker == null) {
            throw new IllegalStateException("You may only add handlers when the Connector is started");
        }
        handler.setMBeanServer(this.server);
        this.invoker.addInvocationHandler(subsystem, handler);
    }

    public void removeInvocationHandler(String subsystem) throws Exception {
        ServerInvocationHandler handler = this.invoker.removeInvocationHandler(subsystem);
        if (handler != null) {
            handler.setMBeanServer(null);
        }
    }
}

