/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.network;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.network.NetworkFilter;
import org.jboss.remoting.network.NetworkInstance;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistryMBean;

public class NetworkRegistry
implements NetworkRegistryMBean {
    private static final Logger log = Logger.getLogger((Class)NetworkRegistry.class);
    private MBeanServer mBeanServer;
    private ObjectName objectName;
    private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
    private final Map servers = new HashMap();
    private static NetworkRegistry singleton;

    public NetworkRegistry() {
        singleton = this;
    }

    public static final NetworkRegistry getInstance() {
        if (singleton == null) {
            new NetworkRegistry();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServer(final Identity identity, final InvokerLocator[] invokers) {
        boolean found = false;
        Map map = this.servers;
        synchronized (map) {
            if (!this.servers.containsKey(identity)) {
                this.servers.put(identity, new NetworkInstance(identity, invokers));
                found = true;
            }
        }
        if (found) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("addServer - " + identity));
            }
            new Thread(){

                public void run() {
                    NetworkRegistry.this.broadcaster.sendNotification((Notification)new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.added", identity, invokers));
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServer(final Identity identity, final InvokerLocator[] invokers) {
        boolean found = false;
        Map map = this.servers;
        synchronized (map) {
            if (this.servers.containsKey(identity)) {
                this.servers.put(identity, new NetworkInstance(identity, invokers));
                found = true;
            }
        }
        if (found) {
            new Thread(){

                public void run() {
                    NetworkRegistry.this.broadcaster.sendNotification((Notification)new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.updated", identity, invokers));
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkInstance[] getServers() {
        Map map = this.servers;
        synchronized (map) {
            return this.servers.values().toArray(new NetworkInstance[this.servers.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasServer(Identity identity) {
        Map map = this.servers;
        synchronized (map) {
            return this.servers.containsKey(identity);
        }
    }

    public NetworkInstance[] queryServers(NetworkFilter filter) {
        NetworkInstance[] servers = this.getServers();
        if (servers == null || servers.length <= 0) {
            return new NetworkInstance[0];
        }
        HashSet<NetworkInstance> result = new HashSet<NetworkInstance>();
        for (int c = 0; c < servers.length; ++c) {
            NetworkInstance instance = (NetworkInstance)this.servers.get(servers[c]);
            if (filter != null && !filter.filter(servers[c].getIdentity(), instance.getLocators()) || result.contains(servers[c])) continue;
            result.add(servers[c]);
        }
        return result.toArray(new NetworkInstance[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServer(final Identity identity) {
        NetworkInstance instance = null;
        Map map = this.servers;
        synchronized (map) {
            instance = (NetworkInstance)this.servers.remove(identity);
        }
        if (instance != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("removeServer - " + identity));
            }
            final InvokerLocator[] il = instance.getLocators();
            new Thread(){

                public void run() {
                    NetworkRegistry.this.broadcaster.sendNotification((Notification)new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.server.removed", identity, il));
                }
            }.start();
        }
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object o) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(notificationListener, notificationFilter, o);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] info = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jboss.network.server.added"}, NetworkNotification.class.getName(), "Fired when Server is added"), new MBeanNotificationInfo(new String[]{"jboss.network.server.updated"}, NetworkNotification.class.getName(), "Fired when Server is updated"), new MBeanNotificationInfo(new String[]{"jboss.network.server.removed"}, NetworkNotification.class.getName(), "Fired when Server is removed")};
        return info;
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(notificationListener);
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean aBoolean) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        Identity identity = Identity.get(this.mBeanServer);
        System.setProperty("jboss.remoting.jmxid", identity.getJMXId());
        System.setProperty("jboss.remoting.instanceid", identity.getInstanceId());
        System.setProperty("jboss.remoting.domain", identity.getDomain());
        return objectName;
    }

    public synchronized void changeDomain(String newDomain) {
        System.setProperty("jboss.remoting.domain", newDomain);
        NetworkInstance[] servers = this.getServers();
        if (servers == null || servers.length <= 0) {
            return;
        }
        for (int c = 0; c < servers.length; ++c) {
            NetworkInstance instance = (NetworkInstance)this.servers.get(servers[c]);
            if (newDomain.equals(instance.getIdentity().getDomain())) continue;
            this.servers.remove(servers[c]);
        }
        new Thread(){

            public void run() {
                NetworkRegistry.this.broadcaster.sendNotification((Notification)new NetworkNotification(NetworkRegistry.this.objectName, "jboss.network.domain.changed", Identity.get(NetworkRegistry.this.mBeanServer), InvokerRegistry.getRegisteredServerLocators()));
            }
        }.start();
    }
}

