/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocationWrapper;
import org.jboss.aop.util.MethodHashing;

public class MethodCalledByMethodInvocation
extends CallerInvocation {
    protected Object[] arguments = null;
    protected long callingMethodHash;
    protected Class callingClass;
    protected Method calledMethod;
    protected Method callingMethod;
    protected Object callingObject;

    public MethodCalledByMethodInvocation(Interceptor[] interceptors, Method calledMethod, Object[] arguments, Class callingClass, long callingMethodHash, Object callingObject) {
        super(interceptors);
        this.calledMethod = calledMethod;
        this.arguments = arguments;
        this.callingClass = callingClass;
        this.callingMethodHash = callingMethodHash;
        this.callingObject = callingObject;
    }

    protected MethodCalledByMethodInvocation(Interceptor[] interceptors) {
        super(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.interceptors != null && this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        try {
            return this.calledMethod.invoke(this.getTargetObject(), this.arguments);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        return null;
    }

    public Invocation getWrapper(Interceptor[] newchain) {
        MethodCalledByMethodInvocationWrapper wrapper = new MethodCalledByMethodInvocationWrapper(this, newchain);
        return wrapper;
    }

    public Invocation copy() {
        MethodCalledByMethodInvocation wrapper = new MethodCalledByMethodInvocation(this.interceptors, this.calledMethod, this.arguments, this.callingClass, this.callingMethodHash, this.callingObject);
        wrapper.setAdvisor(this.getAdvisor());
        wrapper.setTargetObject(this.getTargetObject());
        wrapper.currentInterceptor = this.currentInterceptor;
        wrapper.instanceResolver = this.instanceResolver;
        wrapper.metadata = this.metadata;
        return wrapper;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Class getCallingClass() {
        return this.callingClass;
    }

    public Method getCallingMethod() {
        if (this.callingMethod != null) {
            return this.callingMethod;
        }
        try {
            this.callingMethod = MethodHashing.findMethodByHash(this.callingClass, this.callingMethodHash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.callingMethod;
    }

    public Method getCalledMethod() {
        return this.calledMethod;
    }

    public Object getCallingObject() {
        return this.callingObject;
    }
}

