/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.ExclusiveUse;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.content.application.x_shockwave_flash.AudioCodecPipe;
import com.sun.media.content.application.x_shockwave_flash.JavaSoundPlayer;
import com.sun.media.content.application.x_shockwave_flash.JavaSoundTester;
import com.sun.media.content.application.x_shockwave_flash.SoundMixer;
import com.sun.media.content.application.x_shockwave_flash.SunAudioTester;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;
import sun.audio.AudioPlayer;

public class FlashAudioPlayer {
    public static String MDAR = "com.sun.media.renderer.audio.MixedDirectAudioRenderer";
    public static String DAR = "com.sun.media.renderer.audio.DirectAudioRenderer";
    static AudioCodecPipe codecPipe;
    static AudioFormat ulaw_af;
    static AudioFormat pcm_af;
    public static int rendererUsed;
    public static int ULAWBS;
    public static Vector soundStreams;
    public static FlashAudioPlayer player;
    private static JMFSecurity jmfSecurity;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private int[] slock = new int[0];
    static /* synthetic */ Class class$com$sun$media$util$MediaThread;

    private FlashAudioPlayer() {
        boolean found = false;
        Vector rdNames = PlugInManager.getPlugInList(null, null, 4);
        ULAWBS = 80;
        String jver = null;
        String subjver = null;
        boolean jdk13plus = false;
        try {
            jver = System.getProperty("java.version");
            subjver = jver.length() < 3 ? jver : jver.substring(0, 3);
        }
        catch (Throwable t) {
            jver = null;
            subjver = null;
        }
        jdk13plus = subjver != null && subjver.compareTo("1.3") >= 0;
        if (rdNames != null) {
            int i2 = 0;
            while (i2 < rdNames.size()) {
                String rd = (String)rdNames.elementAt(i2);
                if (rd.indexOf("audio") >= 0 || rd.indexOf("Audio") >= 0) {
                    if (rd.indexOf("JavaSound") > 0 && FlashAudioPlayer.javasoundAvailable()) {
                        rendererUsed = 1;
                        soundStreams = new Vector();
                        found = true;
                        System.out.println("using JavaSound as audio renderer");
                        break;
                    }
                    if (rd.indexOf("DirectAudio") > 0) {
                        Class<?> cls = null;
                        boolean excl = true;
                        try {
                            cls = Class.forName(DAR);
                            excl = ((ExclusiveUse)cls.newInstance()).isExclusive();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                        if (!excl) {
                            rendererUsed = 4;
                            ULAWBS = 800;
                            found = true;
                            System.out.println("using DirectAudioRenderer");
                            break;
                        }
                        rendererUsed = 3;
                        ULAWBS = 80;
                        found = true;
                        System.out.println("using MixedDirectAudioRenderer");
                        break;
                    }
                    if (jdk13plus) {
                        rendererUsed = 1;
                        soundStreams = new Vector();
                        found = true;
                        System.out.println("using JavaSound as audio renderer");
                        break;
                    }
                    if (rd.indexOf("SunAudio") > 0 && FlashAudioPlayer.sunaudioAvailable()) {
                        rendererUsed = 2;
                        soundStreams = new Vector();
                        found = true;
                        System.out.println("using Sun.Audio as audio renderer");
                        break;
                    }
                }
                ++i2;
            }
        }
        if (!found) {
            System.out.println("no audio renderer available");
        } else if (rendererUsed == 3 || rendererUsed == 4) {
            soundStreams = new Vector();
            try {
                Class<?> cls = null;
                cls = rendererUsed == 3 ? Class.forName(MDAR) : Class.forName(DAR);
                Renderer rnd = (Renderer)cls.newInstance();
                ulaw_af = new AudioFormat("ULAW", 8000.0, 8, 1);
                Format[] rfmts = rnd.getSupportedInputFormats();
                AudioFormat[] afmts = new AudioFormat[rfmts.length];
                int i3 = 0;
                while (i3 < rfmts.length) {
                    afmts[i3] = (AudioFormat)rfmts[i3];
                    ++i3;
                }
                codecPipe = new AudioCodecPipe(ulaw_af, afmts, 0);
                pcm_af = (AudioFormat)codecPipe.getOutputFormat();
                rnd.setInputFormat(pcm_af);
                if (rendererUsed == 3) {
                    rnd.open();
                    rnd.start();
                    rnd.stop();
                    rnd.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    static boolean javasoundAvailable() {
        boolean supported = false;
        try {
            Class<?> cls = Class.forName("com.sun.media.content.application.x_shockwave_flash.JavaSoundTester");
            JavaSoundTester jst = (JavaSoundTester)cls.newInstance();
            supported = jst.isSupported();
        }
        catch (Throwable t) {
            supported = false;
        }
        return supported;
    }

    static boolean sunaudioAvailable() {
        boolean supported = false;
        try {
            Class<?> cls = Class.forName("com.sun.media.content.application.x_shockwave_flash.SunAudioTester");
            SunAudioTester sat = (SunAudioTester)cls.newInstance();
            supported = true;
        }
        catch (Throwable t) {
            supported = false;
        }
        return supported;
    }

    public int getActiveSoundNum() {
        return soundStreams.size();
    }

    public int getRendererUsed() {
        return rendererUsed;
    }

    public void removeSoundStream(SoundMixer sm) {
        int[] nArray = this.slock;
        synchronized (nArray) {
            soundStreams.removeElement(sm);
        }
    }

    public void start(byte[] udata, int loopcount) {
        switch (rendererUsed) {
            case 1: {
                JavaSoundPlayer jsp = new JavaSoundPlayer(udata, loopcount);
                int[] nArray = this.slock;
                synchronized (nArray) {
                    soundStreams.addElement(jsp);
                    this.slock.notifyAll();
                }
                jsp.play();
                break;
            }
            case 2: {
                SoundMixer soundMixer = new SoundMixer(udata, loopcount);
                int[] nArray = this.slock;
                synchronized (nArray) {
                    soundStreams.addElement(soundMixer);
                    this.slock.notifyAll();
                }
                AudioPlayer.player.start((InputStream)soundMixer);
                break;
            }
            case 3: 
            case 4: {
                AudioCodecPipe acp = (AudioCodecPipe)codecPipe.clone();
                acp.setBufferSize(ULAWBS);
                Renderer mdar = null;
                try {
                    Class<?> theCls = rendererUsed == 3 ? Class.forName(MDAR) : Class.forName(DAR);
                    mdar = (Renderer)theCls.newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (mdar == null) break;
                SoundMixer thesound = new SoundMixer(udata, loopcount, false, mdar, acp, ULAWBS);
                try {
                    mdar.setInputFormat(pcm_af);
                    mdar.open();
                    if (rendererUsed == 4) {
                        thesound.prefetch();
                    }
                    mdar.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                MediaThread tt = null;
                if (jmfSecurity != null) {
                    String permission = null;
                    try {
                        if (jmfSecurity.getName().startsWith("jmf-security")) {
                            permission = "thread";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                            permission = "thread group";
                            jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                            this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        } else if (jmfSecurity.getName().startsWith("internet")) {
                            PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                            PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                        }
                    }
                    catch (Throwable e2) {
                        securityPrivelege = false;
                    }
                }
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    try {
                        Constructor cons = jdk12CreateThreadRunnableAction.cons;
                        tt = (MediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$util$MediaThread == null ? (class$com$sun$media$util$MediaThread = FlashAudioPlayer.class$("com.sun.media.util.MediaThread")) : class$com$sun$media$util$MediaThread, thesound));
                        cons = jdk12PriorityAction.cons;
                        jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(tt, new Integer(MediaThread.getAudioPriority())));
                    }
                    catch (Exception e3) {}
                } else {
                    tt = new MediaThread(thesound);
                    tt.useAudioPriority();
                }
                tt.setName("SoundStream Thread");
                int[] nArray = this.slock;
                synchronized (nArray) {
                    soundStreams.addElement(thesound);
                    tt.start();
                    this.slock.notifyAll();
                    break;
                }
            }
        }
    }

    public void stop() {
        if (soundStreams.size() <= 0) {
            return;
        }
        switch (rendererUsed) {
            case 1: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    try {
                        int i2 = 0;
                        while (i2 < soundStreams.size()) {
                            JavaSoundPlayer jsp = (JavaSoundPlayer)soundStreams.elementAt(i2);
                            if (jsp != null) {
                                jsp.stop();
                            }
                            ++i2;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    soundStreams.removeAllElements();
                    this.slock.notifyAll();
                    break;
                }
            }
            case 2: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    int i3 = 0;
                    while (i3 < soundStreams.size()) {
                        SoundMixer soundMixer = (SoundMixer)soundStreams.elementAt(i3);
                        if (soundMixer != null) {
                            AudioPlayer.player.stop((InputStream)soundMixer);
                            try {
                                soundMixer.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        ++i3;
                    }
                    soundStreams.removeAllElements();
                    this.slock.notifyAll();
                    break;
                }
            }
            case 3: 
            case 4: {
                int[] nArray = this.slock;
                synchronized (nArray) {
                    int i4 = 0;
                    while (i4 < soundStreams.size()) {
                        SoundMixer ss = (SoundMixer)soundStreams.elementAt(i4);
                        SoundMixer.StopAllStreams();
                        try {
                            ss.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        ss.getMDAR().stop();
                        ss.getMDAR().close();
                        ++i4;
                    }
                    soundStreams.removeAllElements();
                    break;
                }
            }
        }
    }

    public void closeMixedRenderer() {
        if (rendererUsed == 3) {
            int[] nArray = this.slock;
            synchronized (nArray) {
                if (soundStreams.size() > 0) {
                    return;
                }
                try {
                    Class[] paramTypes = new Class[]{};
                    Object[] params = new Object[]{};
                    Class<?> c2 = Class.forName(MDAR);
                    Method m2 = c2.getMethod("closeRenderer", paramTypes);
                    m2.invoke(null, params);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rendererUsed = 0;
        ULAWBS = 80;
        soundStreams = new Vector();
        player = new FlashAudioPlayer();
        jmfSecurity = null;
        securityPrivelege = false;
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

