/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi.factories;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.jboss.deployment.spi.DeploymentManagerImpl;
import org.jboss.logging.Logger;

public class DeploymentFactoryImpl
implements DeploymentFactory {
    private static final Logger log = Logger.getLogger((Class)DeploymentFactoryImpl.class);
    private static String DISPLAY_NAME;
    private static String PRODUCT_VERSION;

    public boolean handlesURI(String uri) {
        boolean handlesURI = false;
        try {
            URI deployURI = this.parseURI(uri);
            String scheme = deployURI.getScheme();
            if (scheme.equals("jboss-deployer")) {
                handlesURI = true;
            }
        }
        catch (URISyntaxException e) {
            log.warn((Object)("Failed to parse uri: " + uri), (Throwable)e);
        }
        log.debug((Object)("handlesURI [" + uri + "]: " + handlesURI));
        return handlesURI;
    }

    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        log.debug((Object)("getDeploymentManager (uri=" + uri + ")"));
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Cannot handle URI: " + uri);
        }
        DeploymentManagerImpl mgr = null;
        try {
            URI deployURI = this.parseURI(uri);
            mgr = new DeploymentManagerImpl(deployURI, true, userName, password);
        }
        catch (URISyntaxException e) {
            DeploymentManagerCreationException ex = new DeploymentManagerCreationException("Failed to create DeploymentManagerImpl");
            ex.initCause((Throwable)e);
            throw ex;
        }
        return mgr;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        log.debug((Object)("getDisconnectedDeploymentManager (uri=" + uri + ")"));
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Cannot handle URI: " + uri);
        }
        DeploymentManagerImpl mgr = null;
        try {
            URI deployURI = this.parseURI(uri);
            mgr = new DeploymentManagerImpl(deployURI, false);
        }
        catch (URISyntaxException e) {
            DeploymentManagerCreationException ex = new DeploymentManagerCreationException("Failed to create DeploymentManagerImpl");
            ex.initCause((Throwable)e);
            throw ex;
        }
        return mgr;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getProductVersion() {
        return PRODUCT_VERSION;
    }

    private URI parseURI(String uri) throws URISyntaxException {
        URI deployURI;
        try {
            deployURI = uri.equals("jboss-deployer") ? new URI(uri + "://" + InetAddress.getLocalHost().getHostName()) : new URI(uri);
        }
        catch (UnknownHostException e) {
            throw new URISyntaxException(uri, e.toString());
        }
        return deployURI;
    }

    static {
        Package pkg = Package.getPackage("org.jboss.deploy.spi.factories");
        if (pkg != null) {
            DISPLAY_NAME = pkg.getImplementationVendor();
            PRODUCT_VERSION = pkg.getImplementationVersion();
        }
        if (DISPLAY_NAME == null || PRODUCT_VERSION == null) {
            DISPLAY_NAME = "DeploymentFactoryImpl";
            PRODUCT_VERSION = "1.1";
        }
    }
}

