/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.server;

// $Id$

import org.jboss.axis.Handler;
import org.jboss.axis.MessageContext;
import org.jboss.axis.providers.java.RPCProvider;

import javax.xml.rpc.holders.IntHolder;
import java.lang.reflect.Method;

/**
 * A very simple reflection provider that invokes the method on the object
 * that is given in the constructor of this provider.
 *
 * @author thomas.diesler@jboss.org
 * @version $Revision$
 */
public class InvokerProviderSimple extends RPCProvider
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 6368971333868010325L;
   private Object targetService;

   /** Creates new InvokerProviderSimple
    */
   public InvokerProviderSimple(Object targetService)
   {
      this.targetService = targetService;
   }

   /**
    * This method encapsulates the method invocation.
    *
    * @param msgContext MessageContext
    * @param method     the target method.
    * @param obj        the target object
    * @param argValues  the method arguments
    */
   protected java.lang.Object invokeMethod(MessageContext msgContext, Method method, java.lang.Object obj, java.lang.Object[] argValues) throws Exception
   {
      return method.invoke(obj, argValues);
   }

   /**
    * Get the service object whose method actually provides the service.
    * May look up in session table.
    */
   public java.lang.Object getServiceObject(MessageContext msgContext, Handler service, String clsName, IntHolder scopeHolder) throws Exception
   {
      return targetService;
   }

   /**
    * Return the class name of the service
    */
   protected String getServiceClassName(Handler service)
   {
      return targetService.getClass().getName();
   }
}
