/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.encoding.ser;

// $Id$

import org.jboss.axis.Constants;
import org.jboss.axis.encoding.ser.ArraySerializer;

import javax.xml.namespace.QName;
import java.math.BigDecimal;

/**
 * DOCUMENT ME!
 *
 * @author thomas.diesler@jboss.org
 */
public class SOAPArraySerializer extends ArraySerializer
{
   public SOAPArraySerializer(Class javaType, QName xmlType)
   {
      addComponentTypeMapping(String.class, new QName(Constants.URI_SOAP11_ENC, "string"));
      addComponentTypeMapping(Boolean.class, new QName(Constants.URI_SOAP11_ENC, "boolean"));
      addComponentTypeMapping(Float.class, new QName(Constants.URI_SOAP11_ENC, "float"));
      addComponentTypeMapping(Double.class, new QName(Constants.URI_SOAP11_ENC, "double"));
      addComponentTypeMapping(BigDecimal.class, new QName(Constants.URI_SOAP11_ENC, "decimal"));
      addComponentTypeMapping(Integer.class, new QName(Constants.URI_SOAP11_ENC, "int"));
      addComponentTypeMapping(Short.class, new QName(Constants.URI_SOAP11_ENC, "short"));
      addComponentTypeMapping(Byte.class, new QName(Constants.URI_SOAP11_ENC, "byte"));
      addComponentTypeMapping(byte[].class, new QName(Constants.URI_SOAP11_ENC, "base64"));
   }
}
