/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice;

/**
 * MBean interface.
 * @since 27-April-2004
 */
public interface ServiceClientDeployerMBean extends org.jboss.system.ServiceMBean
{

   //default object name
   public static final javax.management.ObjectName OBJECT_NAME = org.jboss.mx.util.ObjectNameFactory
         .create("jboss.ws4ee:service=ServiceClientDeployer");

   /**
    * This binds a jaxrpc Service into the callers ENC for every service-ref element
    * @param envCtx ENC to bind the javax.rpc.xml.Service object to
    * @param serviceRefs An iterator of the service-ref elements in the client deployment descriptor
    * @param di The client's deployment info
    * @throws org.jboss.deployment.DeploymentException if it goes wrong
    */
   void setupServiceRefEnvironment(javax.naming.Context envCtx, java.util.Iterator serviceRefs,
         org.jboss.deployment.DeploymentInfo di) throws org.jboss.deployment.DeploymentException;

}
