package examples;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;


/**
 * @author Ben Wang
 */
public class Student extends Person 
{
   protected String school;
   protected Set   courses = new LinkedHashSet();

   public void setSchool(String school)
   {
      this.school = school;
   }

   public String getSchool()
   {
      return this.school;
   }
   
   public void addCourse(Course course)
   {
      courses.add(course);
   }
   
   public void removeCourse(Course course)
   {
      courses.remove(course);
   }
   
   public Set getCourses()
   {
      return Collections.unmodifiableSet(courses);
   }

   public String toString()
   {
      StringBuffer buf = new StringBuffer();
      buf.append("{Name = " +name).append(", School = " +school);
      if (address != null)
         buf.append(", Address = " + address.getSimpleAddress());
      buf.append("}\n");
      buf.append("Courses:\n");
      for (Iterator iter = getCourses().iterator(); iter.hasNext(); )
         buf.append(iter.next());

      return buf.toString();
   }

}
