/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbws710;

import junit.framework.Test;
import org.jboss.test.webservice.WebserviceTestBase;

import javax.naming.InitialContext;
import javax.xml.rpc.Service;

/**
 * Document/Literal webservices that are oneway
 *
 * http://jira.jboss.com/jira/browse/JBWS-710
 *
 * @author Thomas.Diesler@jboss.org
 * @since 15-Feb-2006
 */
public class JBWS710TestCase extends WebserviceTestBase
{
   private static Hello port;

   public JBWS710TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS710TestCase.class, "ws4ee-jbws710.war, ws4ee-jbws710-client.jar");
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      if (port == null)
      {
         InitialContext iniCtx = getClientContext();
         Service service = (Service)iniCtx.lookup("java:comp/env/service/HelloService");
         port = (Hello)service.getPort(Hello.class);
      }
   }

   public void testOnewayRequest() throws Exception
   {
      port.onewayRequest("str1", "str2", "str3");

      String retObj = null;
      for (int i = 0; retObj == null && i < 5; i++)
         retObj = port.onewayResponse();

      assertEquals("str1str2str3", retObj);
   }
}
