/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbas897;

import java.io.IOException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

import org.jboss.deployment.DeploymentException;
import org.jboss.test.webservice.WebserviceTestBase;

/**
 * I made a typo in my ejb-jar.xml file so it didn't match the
 * <ejb-link> within my webservices.xml file. No complaint
 * from JBoss on deployment on this.

 * http://jira.jboss.com/jira/browse/JBAS-897
 *
 * @author Thomas.Diesler@jboss.org
 * @since 04-Feb-2005
 */
public class JBAS897TestCase extends WebserviceTestBase
{
   private String NAMESPACE = "http://org.jboss.test.webservice/jbas897";

   private QName SERVICE_NAME = new QName(NAMESPACE, "HelloService");

   /**
    * Construct the test case with a given name
    */
   public JBAS897TestCase(String name)
   {
      super(name);
   }

   /**
    * Test JSE endpoint
    */
   public void testJSEEndpoint() throws Exception
   {
      deploy("ws4ee-jbas897.war");
      try
      {
         ServiceFactory serviceFactory = ServiceFactory.newInstance();
         Service service = serviceFactory.createService(new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897/HelloJSE?wsdl"), SERVICE_NAME);
         Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPort"), "sayHello");
         String retstr = (String)call.invoke(new Object[] { "Hello" });
         assertEquals("'Hello' to you too!", retstr);
      }
      finally
      {
         undeploy("ws4ee-jbas897.war");
      }
   }

   /**
    * Test JSE endpoint with invalid deployment
    */
   public void testJSEEndpointFail() throws Exception
   {
      try
      {
         try
         {
            deploy("ws4ee-jbas897-fail.war");
         }
         catch (DeploymentException e)
         {
            // expected
         }

         try
         {
            URL url = new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897-fail/HelloJSE");
            url.openStream();
            fail("Deployment was expected to fail");
         }
         catch (IOException e)
         {
            // expected
         }
      }
      finally
      {
         undeploy("ws4ee-jbas897-fail.war");
      }
   }

   /**
    * Test EJB endpoint
    */
   public void testEJBEndpoint() throws Exception
   {
      deploy("ws4ee-jbas897.jar");
      try
      {
         ServiceFactory serviceFactory = ServiceFactory.newInstance();
         Service service = serviceFactory.createService(new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897/HelloEJB?wsdl"), SERVICE_NAME);
         Call call = (Call)service.createCall(new QName(NAMESPACE, "HelloPort"), "sayHello");
         String retstr = (String)call.invoke(new Object[] { "Hello" });
         assertEquals("'Hello' to you too!", retstr);
      }
      finally
      {
         undeploy("ws4ee-jbas897.jar");
      }
   }

   /**
    * Test EJB endpoint
    */
   public void testEJBEndpointFail() throws Exception
   {
      try
      {
         try
         {
            deploy("ws4ee-jbas897-fail.jar");
         }
         catch (DeploymentException e)
         {
            // expected
         }

         try
         {
            URL url = new URL("http://" + getServerHost() + ":8080/ws4ee-jbas897-fail/HelloEJB");
            url.openStream();
            fail("Deployment was expected to fail");
         }
         catch (IOException e)
         {
            // expected
         }
      }
      finally
      {
         undeploy("ws4ee-jbas897-fail.jar");
      }
   }
}
