/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.varia.property;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;

import java.util.Properties;

import org.jboss.test.JBossTestCase;
import org.jboss.varia.property.PropertyEditorManagerService;

/** Unit tests for the PropertyEditorManagerServiceTestCase utility service.
 *
 * @see org.jboss.varia.property.PropertyEditorManagerService
 * @author genman@jboss.org
 * 
 * @version $Revision$
 */
public class PropertyEditorManagerServiceTestCase extends JBossTestCase
{

   PropertyEditorManagerService s = new PropertyEditorManagerService();
   Class bc = Byte.class;
   Class be = org.jboss.util.propertyeditor.ByteEditor.class;
   Class sc = String.class;
   Class de = DummyEditor.class;

   public PropertyEditorManagerServiceTestCase(String name)
   {
      super(name);
   }

   public static class DummyEditor extends java.beans.PropertyEditorSupport
   {
      public void setAsText(String s)
      {
         setValue(s);
      }
   }

   protected void setUp()
   {
      getLog().debug("+++ " + getName());
      PropertyEditorManager.registerEditor(bc, null);
      PropertyEditorManager.registerEditor(sc, null);
   }

   /** 
    * Tests opertions.
    * @throws Exception
    */ 
   public void testOperations()
      throws Exception
   {
      s.registerEditor(bc, be);
      assertEquals(be, s.findEditor(bc).getClass());
      assertEquals(be, s.findEditor("java.lang.Byte").getClass());
      s.registerEditor(bc.getName(), be.getName());

      String ed = "org.jboss.util.propertyeditor,org.example.editor";
      s.setEditorSearchPath(ed);
      assertEquals(ed, s.getEditorSearchPath());

      s.setBootstrapEditors(
            "# COMMENT \n" + 
            sc.getName() + "=" + de.getName() + "\n");
      assertEquals(de, s.findEditor(sc).getClass());
      Properties p = new Properties();
      p.put(sc.getName(), de.getName());
      s.setEditors(p);
      assertEquals(de, s.findEditor(sc).getClass());
   }

   public void testUnregister()
      throws Exception
   {
      PropertyEditorManagerService s = new PropertyEditorManagerService();
      Class tc = Thread.class;
      s.registerEditor(tc, de);
      assertEquals(tc, s.getRegisteredEditors()[0]);
      s.start();
      s.destroy();
      assertEquals(null, s.findEditor(tc));
      assertEquals(null, PropertyEditorManager.findEditor(tc));
      assertEquals(0, s.getRegisteredEditors().length);
   }

}

