/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.tm.resource;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

import org.jboss.tm.LastResource;

/**
 * A LocalResource.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class LocalResource extends Resource implements LastResource
{
   /** Whether to fail the commit */
   private boolean failLocal = false;
   
   /**
    * Create a new LocalResource.
    * 
    * @param id the id
    */
   public LocalResource(Integer id)
   {
      super(id);
   }

   public void failLocal()
   {
      failLocal = true;
   }
   
   public int prepare(Xid xid) throws XAException
   {
      XAException e = new XAException("Prepare called on local resource");
      e.errorCode = XAException.XAER_PROTO;
      throw e;
   }

   public void commit(Xid xid, boolean onePhase) throws XAException
   {
      State state = getState(xid);
      if (state.resState != ACTIVE && state.resState != ENDED)
      {
         state.resState = ERROR;
         throw new XAException(XAException.XAER_PROTO);
      }
      if (failLocal)
      {
         state.resState = ROLLEDBACK;
         state.removed = true;
         throw new XAException(XAException.XA_RBROLLBACK);
      }
      else
      {
         state.resState = COMMITTED;
         state.removed = true;
      }
   }

   public boolean isSameRM(XAResource res)
   {
      return res == this;
   }
}
