package org.jboss.test.marshal.test;

import junit.framework.Test;
import org.jboss.test.JBossTestCase;
import org.jboss.test.marshal.TestPayload;
import org.jboss.test.marshal.interfaces.MarshalSession;
import org.jboss.test.marshal.interfaces.MarshalSessionHome;

import java.rmi.MarshalException;

/**
 * Test that unmarshall exception is thrown.
 *
 * @author  <a href="mailto:tom@jboss.org">Tom Elrod</a>
 * @version $Revision$
 */
public class EjbUnMarshalUnitTestCase extends JBossTestCase
{
   public EjbUnMarshalUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
      throws Exception
   {
      return getDeploySetup(EjbUnMarshalUnitTestCase.class, "test-ejb-unmarshal.jar");
   }

   /**
    * This is a simple test which calls on the MarshalSession bean, passing a TestPayload
    * object as the parameter.  The deployed jar with the MarshalSession should NOT contain
    * the TestPayload class, thus cause there to be a UnmarshalException to be thrown.
    * @throws Exception
    */
   public void testUnMarshalException() throws Exception
   {
      MarshalSessionHome marshalHome = (MarshalSessionHome)getInitialContext().lookup("marshal/MarshallSession");
      MarshalSession marshalSession = marshalHome.create();

      TestPayload payload = new TestPayload();
      try
      {
         marshalSession.testMethod(payload);
         assertTrue("Call on MarshalSession.testMethod() should have thrown UnmarshalException, but did not", false);
      }
      catch (MarshalException e)
      {
         assertTrue(true);
      }
      catch (Throwable thr)
      {
         thr.printStackTrace();
         throw new Exception(thr);
      }

   }

}
