/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.jca.test;

import javax.resource.cci.Connection;
import javax.transaction.Transaction;

/**
 * Contentious pooling stress test.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class ContentiousInterleavingStressTestCase extends AbstractContentiousPoolingStressTest
{
   public void testIt() throws Throwable
   {
      tm.setTransactionTimeout(0);
      tm.begin();
      final Transaction tx = tm.suspend();
      ContentiousPoolingRunnable[] runnables = new ContentiousPoolingRunnable[getThreadCount()];
      for (int i = 0; i < runnables.length; ++i)
      {
         runnables[i] = new ContentiousPoolingRunnable(tx)
         {
            public void doRun() throws Throwable
            {
               Connection c = cf.getConnection();
               c.close();
            }
         };
      }

      runConcurrentTest(runnables, new ConcurrentTestCallback()
            {
               public void finished() throws Throwable
               {
                  tm.resume(tx);
                  tm.commit();
               }
            });
   }
   
   public ContentiousInterleavingStressTestCase(String name)
   {
      super(name);
   }
}
