package org.jboss.test.cluster.test;

import junit.framework.Test;

import org.jboss.test.JBossClusteredTestCase;

/**
 * Tests that a clustered session still functions properly on the second
 * node after the webapp is undeployed from the first node.
 * <p/>
 * This version tests an AttributeBasedClusteredSession.
 * 
 * @author Brian Stansberry
 * @version $Id$
 */
public class UndeployAttrTestCase extends UndeployTestCase
{

   public UndeployAttrTestCase(String name)
   {
      super(name);
   }
   
   protected String getContextPath()
   {
      return "/http-scoped-attr/";
   }
   
   protected String getWarName()
   {
      return "http-scoped-attr.war";
   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(UndeployAttrTestCase.class,
            "http-scoped-attr.war");
      return t1;
   }

}
