/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.system.server;

/**
 * MBean interface.
 */
public interface ServerInfoMBean
{

   //default object name
   public static final javax.management.ObjectName OBJECT_NAME = org.jboss.mx.util.ObjectNameFactory
         .create("jboss.system:type=ServerInfo");

   java.lang.String getJavaVersion();

   java.lang.String getJavaVendor();

   java.lang.String getJavaVMName();

   java.lang.String getJavaVMVersion();

   java.lang.String getJavaVMVendor();

   java.lang.String getOSName();

   java.lang.String getOSVersion();

   java.lang.String getOSArch();

   java.lang.Long getTotalMemory();

   java.lang.Long getFreeMemory();

   /**
    * Returns <tt>Runtime.getRuntime().maxMemory()<tt> on JDK 1.4 vms or -1 on previous versions.
    */
   java.lang.Long getMaxMemory();

   /**
    * Returns <tt>Runtime.getRuntime().availableProcessors()</tt> on JDK 1.4 vms or -1 on previous versions.
    */
   java.lang.Integer getAvailableProcessors();

   /**
    * Returns InetAddress.getLocalHost().getHostName();
    */
   java.lang.String getHostName();

   /**
    * Returns InetAddress.getLocalHost().getHostAddress();
    */
   java.lang.String getHostAddress();

   /**
    * Return a listing of the thread pools on jdk5+.
    * @param fancy produce a text-based graph when true    */
   java.lang.String listMemoryPools(boolean fancy);

   java.lang.Integer getActiveThreadCount();

   java.lang.Integer getActiveThreadGroupCount();

   /**
    * Return a listing of the active threads and thread groups.
    */
   java.lang.String listThreadDump();

   /**
    * Return a sort list of thread cpu utilization.
    */
   String listThreadCpuUtilization();

   /**
    * Display the java.lang.Package info for the pkgName
    */
   java.lang.String displayPackageInfo(java.lang.String pkgName);

   /**
    * Display the ClassLoader, ProtectionDomain and Package information for the specified class.
    * @return a simple html report of this information
    */
   java.lang.String displayInfoForClass(java.lang.String className) throws java.lang.Exception;

}
