/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/

package org.jboss.spring.interceptor;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.spring.support.SpringInjectionSupport;

/**
 * Injects Spring beans on ConstructorInterceptor invocation.
 * Should be the last interceptor in chain since it actually constructs EJB object
 * (in order to inject beans).
 *
 * @see SpringInjectionSupport
 *
 * @author <a href="mailto:ales.justin@genera-lynx.com">Ales Justin</a>
 */
public class SpringInjectionInterceptor extends SpringInjectionSupport implements Interceptor {

    public SpringInjectionInterceptor() {
        log.info("Instantiating " + getName());
    }

    public String getName() {
        return "SpringInjectionInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (!(invocation instanceof ConstructorInvocation)) {
            throw new IllegalArgumentException("This interceptor is meant to be applied" +
                                               " only on new instantiation of EJB objects");
        }
        Object target = invocation.invokeNext();
        inject(target);
        return target;
    }

}
