/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.axis.utils;

// $Id$

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/** A JDK-1.3 implementation of a LinkedHashMap
 *
 * @author Thomas.Diesler@jboss.org
 * @since 12-Nov-2004
 */
public class LinkedHashMap implements Map
{

   private HashMap delegate = new HashMap();
   private OrderedSet keys = new OrderedSet();

   public int size()
   {
      return delegate.size();
   }

   public boolean isEmpty()
   {
      return delegate.isEmpty();
   }

   public boolean containsKey(Object key)
   {
      return delegate.containsKey(key);
   }

   public boolean containsValue(Object value)
   {
      return delegate.containsValue(value);
   }

   public Object get(Object key)
   {
      return delegate.get(key);
   }

   public Object put(Object key, Object value)
   {
      Object obj = delegate.put(key, value);
      keys.add(key);
      return obj;
   }

   public Object remove(Object key)
   {
      Object obj = delegate.remove(key);
      keys.remove(key);
      return obj;
   }

   public void putAll(Map t)
   {
      Iterator it = t.keySet().iterator();
      while (it.hasNext())
      {
         Object key = it.next();
         Object val = t.get(key);
         put(key, val);
      }
   }

   public void clear()
   {
      delegate.clear();
      keys.clear();
   }

   public Set keySet()
   {
      OrderedSet set = new OrderedSet();
      set.addAll(keys);
      return set;
   }

   public Collection values()
   {
      ArrayList list = new ArrayList();
      Iterator it = keySet().iterator();
      while (it.hasNext())
      {
         Object key = it.next();
         Object val = get(key);
         list.add(val);
      }
      return list;
   }

   public Set entrySet()
   {
      OrderedSet set = new OrderedSet();
      Iterator it = keySet().iterator();
      while (it.hasNext())
      {
         Object key = it.next();
         Object val = get(key);
         set.add(new Entry(key, val));
      }
      return set;
   }

   public static class Entry implements Map.Entry
   {
      private Object key;
      private Object val;

      public Entry(Object key, Object val)
      {
         this.key = key;
         this.val = val;
      }

      public Object getKey()
      {
         return key;
      }

      public Object getValue()
      {
         return val;
      }

      public Object setValue(Object value)
      {
         this.val = value;
         return val;
      }
   }

   public class OrderedSet implements Set
   {

      private ArrayList delegate = new ArrayList();

      public int size()
      {
         return delegate.size();
      }

      public boolean isEmpty()
      {
         return delegate.isEmpty();
      }

      public boolean contains(Object o)
      {
         return delegate.contains(o);
      }

      public Iterator iterator()
      {
         return delegate.iterator();
      }

      public Object[] toArray()
      {
         return delegate.toArray();
      }

      public Object[] toArray(Object a[])
      {
         return delegate.toArray(a);
      }

      public boolean add(Object o)
      {
         return delegate.add(o);
      }

      public boolean remove(Object o)
      {
         return delegate.remove(o);
      }

      public boolean containsAll(Collection c)
      {
         return delegate.containsAll(c);
      }

      public boolean addAll(Collection c)
      {
         return delegate.addAll(c);
      }

      public boolean retainAll(Collection c)
      {
         return delegate.retainAll(c);
      }

      public boolean removeAll(Collection c)
      {
         return delegate.removeAll(c);
      }

      public void clear()
      {
         delegate.clear();
      }
   }
}
