/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$


/**
 * A basic event handler interface for validation errors.
 *
 * If an application needs to implement customized event handling, it must implement this interface and then register
 * it with either the Unmarshaller, the Validator, or the Marshaller. The JAXB Provider will then report validation
 * errors and warnings encountered during the unmarshal, marshal, and validate operations to these event handlers.
 *
 * If the handleEvent method throws an unchecked runtime exception, the JAXB Provider must treat that as if the method
 * returned false, effectively terminating whatever operation was in progress at the time (unmarshal, validate, or marshal).
 *
 * Modifying the Java content tree within your event handler is undefined by the specification and may result in unexpected behaviour.
 *
 * Failing to return false from the handleEvent method after encountering a fatal error is undefined by the specification
 * and may result in unexpected behavior.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface ValidationEventHandler
{
   /** Receive notification of a validation warning or error.
    */
   boolean handleEvent(ValidationEvent event);
}
