/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

import org.xml.sax.ContentHandler;

/**
 * Unmarshaller implemented as SAX ContentHandler.
 *
 * Applications can use this interface to use their JAXB provider as a component in an XML pipeline. For example:
 *
 * <pre>
 *     JAXBContext context = JAXBContext.newInstance( "org.acme.foo" );
 *
 *     Unmarshaller unmarshaller = context.createUnmarshaller();
 *
 *     UnmarshallerHandler unmarshallerHandler = unmarshaller.getUnmarshallerHandler();
 *
 *     SAXParserFactory spf = SAXParserFactory.newInstance();
 *     spf.setNamespaceAware( true );
 *
 *     XMLReader xmlReader = spf.newSAXParser().getXMLReader();
 *     xmlReader.setContentHandler( unmarshallerHandler );
 *     xmlReader.parse(new InputSource( new FileInputStream( XML_FILE ) ) );
 *
 *     MyObject myObject= (MyObject)unmarshallerHandler.getResult();
 * </pre>
 *
 * This interface is reusable: even if the user fails to unmarshal an object, s/he can still start a new round of unmarshalling.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface UnmarshallerHandler extends ContentHandler
{
   /** Obtains the unmarshalled result.
    */
   Object getResult() throws JAXBException, IllegalStateException;
}
