/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

/**
 * This exception indicates that an error was encountered while getting or setting a property.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public class PropertyException extends JAXBException
{
   /** Construct a PropertyException with the specified detail message. */
   public PropertyException(String message)
   {
      super(message);
   }

   /** Construct a PropertyException whose message field is set based on the name of the property and value.toString(). */
   public PropertyException(String message, Object value)
   {
      super(message + " - [" + value.toString() + "]");
   }

   /** Construct a PropertyException with the specified detail message and vendor specific errorCode. */
   public PropertyException(String message, String errorCode)
   {
      super(message, errorCode);
   }

   /** Construct a PropertyException with the specified detail message, vendor specific errorCode, and linkedException. */
   public PropertyException(String message, String errorCode, Throwable exception)
   {
      super(message, errorCode, exception);
   }


   /** Construct a PropertyException with the specified detail message and linkedException. */
   public PropertyException(String message, Throwable exception)
   {
      super(message, exception);
   }

   /** Construct a PropertyException with a linkedException. */
   public PropertyException(Throwable exception)
   {
      super(exception);
   }

}
