/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$

/**
 * This is the root exception class for all JAXB exceptions.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 * @version $Revision$
 */
public class JAXBException extends Exception
{
   /** @since 4.0.4 */
   static final long serialVersionUID = -1795805848732208234L;
   private String errorCode;

   /** Construct a JAXBException with the specified detail message.
    */
   public JAXBException(String message)
   {
      super(message);
   }

   /** Construct a JAXBException with the specified detail message and vendor specific errorCode.
    */
   public JAXBException(String message, String errorCode)
   {
      super(message);
      this.errorCode = errorCode;
   }

   /** Construct a JAXBException with the specified detail message, vendor specific errorCode, and linkedException.
    */
   public JAXBException(String message, String errorCode, Throwable exception)
   {
      super(message, exception);
      this.errorCode = errorCode;
   }

   /** Construct a JAXBException with the specified detail message and linkedException.
    */
   public JAXBException(String message, Throwable exception)
   {
      super(message, exception);
   }

   /** Construct a JAXBException with a linkedException.
    */
   public JAXBException(Throwable exception)
   {
      super(exception);
   }

   /** Get the vendor specific error code
    */
   public String getErrorCode()
   {
      return errorCode;
   }

   /** Get the linked exception
    */
   public Throwable getLinkedException()
   {
      return getCause();
   }

   /** Add a linked Exception.
    */
   public void setLinkedException(Throwable exception)
   {
      initCause(exception);
   }
}
