/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.strictpool;

import javax.annotation.Resource;
import javax.ejb.EJBException;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import org.jboss.annotation.ejb.PoolClass;


/**
 * Adapted from the EJB 2.1 tests (org.jboss.test.cts.ejb.StrictlyPooledSessionBean)
 * @author <a href="mailto:kabir.khan@jboss.org">Kabir Khan</a>
 * @version $Revision$
 */
@Stateless
@PoolClass (value=org.jboss.ejb3.StrictMaxPool.class, maxSize=StrictlyPooledSessionBean.maxActiveCount, timeout=10000)
@Remote(StrictlyPooledSession.class)
public class StrictlyPooledSessionBean implements StrictlyPooledSession
{
   /** The class wide max count of instances allows */
   public static final int maxActiveCount = 5;
   /** The class wide count of instances active in business code */
   private static int activeCount;

   private SessionContext ctx;

   @Resource public void setSessionContext(SessionContext ctx)
   {
      System.out.println("setSessionContext()");
      this.ctx = ctx;
   }

   public void methodA()
   {
      int count = incActiveCount();
      System.out.println("Begin methodA, activeCount="+count+", ctx="+ctx);
      try
      {
         if( count > maxActiveCount )
         {
            String msg = "IllegalState, activeCount > maxActiveCount, "
                  + count + " > " + maxActiveCount;
            throw new EJBException(msg);
         }
         // Sleep to let the client thread pile up
         Thread.currentThread().sleep(1000);
      }
      catch(InterruptedException e)
      {
      }
      finally
      {
         count = decActiveCount();
         System.out.println("End methodA, activeCount="+count+", ctx="+ctx);
      }
   }

   private static synchronized int incActiveCount()
   {
      return activeCount ++;
   }
   private static synchronized int decActiveCount()
   {
      return activeCount --;
   }

}
