/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.stateful;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.ejb.Stateful;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
@Stateful
public class StatefulSyncBean implements SessionSynchronization, StatefulSyncLocal, java.io.Serializable
{
   private String state;
   private String rollbackState;
   private boolean beforeCalled;

   public boolean isBeforeCalled()
   {
      return beforeCalled;
   }

   public void setBeforeCalled(boolean beforeCalled)
   {
      this.beforeCalled = beforeCalled;
   }

   public String getState()
   {
      return state;
   }

   public void setState(String state)
   {
      this.state = state;
   }


   public void afterBegin() throws EJBException, RemoteException
   {
      rollbackState = state;
   }

   public void beforeCompletion() throws EJBException, RemoteException
   {
      beforeCalled = true;
   }

   public void afterCompletion(boolean committed) throws EJBException, RemoteException
   {
      if (!committed) state = rollbackState;  
   }
}
