/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.security;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import java.security.Principal;

import javax.annotation.security.RunAs;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

/**
 * An interceptor that enforces the run-as identity declared by a bean.
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>.
 * @version $Revision$
 */
public class RunAsSecurityInterceptor extends org.jboss.aspects.security.RunAsSecurityInterceptor
{
   private static final Logger log = Logger.getLogger(RunAsSecurityInterceptor.class);
   
   public RunAsSecurityInterceptor(AuthenticationManager manager, RealmMapping realmMapping)
   {
      super(manager, realmMapping);
   }
   
   protected RunAsIdentity getRunAsIdentity(Invocation invocation)
   {
      RunAsIdentity runAsRole = null;
      RunAs runAs = (RunAs) invocation.resolveClassAnnotation(RunAs.class);
      if (runAs == null) return null;
      Principal principal = SecurityAssociation.getPrincipal();
      Set extraRoles = realmMapping.getUserRoles(principal);
      if (extraRoles != null)
      {
         Iterator roles = extraRoles.iterator();
         Set extraRoleNames = new HashSet();
         while (roles.hasNext())
         {
            extraRoleNames.add( ((SimplePrincipal)roles.next()).getName());
         }
         if (principal == null)
            runAsRole = new RunAsIdentity(runAs.value(), null, extraRoleNames);
         else
            runAsRole = new RunAsIdentity(runAs.value(), principal.getName(), extraRoleNames);
      } else
      {
         runAsRole = new RunAsIdentity(runAs.value(), null);
      }
      
      return runAsRole;
   }
   
   public Object invoke(Invocation invocation) throws Throwable
   {
      try 
      {
         return super.invoke(invocation);
      } finally {
      }
   }

}
