/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.jws;

// $Id$

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a Java class as implementing a Web Service, or a Java interface as defining a Web Service interface.
 *
 * @author thomas.diesler@jboss.org
 * @since 26-Apr-2005
 */
@Retention(value = RetentionPolicy.RUNTIME)
   @Target(value = {ElementType.TYPE})
   public @interface WebService
{

   /**
    * The name of the Web Service.  Used as the name of the wsdl:portType when mapped to WSDL 1.1.
    * Defaults to the simple name of the Java class or interface
    */
   String name() default "";

   /**
    * The XML namespace used for the WSDL and XML elements generated from this Web Service.
    */
   String targetNamespace() default "";

   /**
    * The service name of the Web Service.  Used as the name of the wsdl:service when mapped to WSDL 1.1.
    * Not allowed on interfaces.  Defaults to the simple name of the Java class + Service".
    */
   String serviceName() default "";

   /**
    * The location of a pre-defined WSDL describing the service.  The wsdlLocation is a URL (relative or absolute)
    * that refers to a pre-existing WSDL file.  The presence of a wsdlLocation value indicates that the service
    * implementation bean is implementing a pre-defined WSDL contract.  The JSR-181 tool should instead feedback
    * if the service implementation bean is inconsistent with the portType and bindings declared in this WSDL. Note
    * that a single WSDL file might contain multiple portTypes and multiple bindings.  The annotations on the service
    * implementation bean determine the specific portType and bindings that correspond to the Web Service.
    */
   String wsdlLocation() default "";

   /**
    * The complete name of the service endpoint interface defining the services abstract Web Service contract.   This
    * annotation allows the developer to separate the interface contract from the implementation.  If this annotation
    * is present, the service endpoint interface is used to determine the abstract WSDL contract (portType and
    * bindings). The service endpoint interface may include JSR-181 annotations to customize the mapping from Java to
    * WSDL.  The service implementation bean may implement the service endpoint interface, but is not required to do
    * so.
    *
    * If this annotation is not present, the Web Service contract will be generated from annotations on the service
    * implementation bean itself.  If a service endpoint interface is required by the target environment, it will be
    * generated into an implementation-defined package with an implementation defined name.
    */
   String endpointInterface() default "";
}

;
