/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.idl.Case;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.UnionType;
import org.jacorb.idl.parser;

class SwitchBody
extends IdlSymbol {
    Vector caseListVector = new Vector();
    TypeSpec ts = null;
    UnionType myUnion = null;

    public SwitchBody(int num) {
        super(num);
    }

    public void setTypeSpec(TypeSpec s) {
        this.ts = s;
        Enumeration e = this.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case c = (Case)e.nextElement();
            c.setPackage(this.pack_name);
            c.setTypeSpec(s);
        }
    }

    public void setUnion(UnionType ut) {
        this.myUnion = ut;
        Enumeration e = this.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case c = (Case)e.nextElement();
            c.setUnion(ut);
        }
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
        Enumeration e = this.caseListVector.elements();
        while (e.hasMoreElements()) {
            ((IdlSymbol)e.nextElement()).setEnclosingSymbol(s);
        }
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        if (this.ts != null) {
            this.ts.setPackage(s);
        }
    }

    public void parse() {
        Hashtable<String, IdlSymbol> usedLabelNames = new Hashtable<String, IdlSymbol>();
        Enumeration e = this.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case theCase = (Case)e.nextElement();
            theCase.parse();
            IdlSymbol[] labels = theCase.getLabels();
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] == null) continue;
                IdlSymbol sym2 = (IdlSymbol)usedLabelNames.get(labels[i].toString());
                if (sym2 != null) {
                    parser.error("Duplicate case label <" + sym2.toString() + ">", sym2.get_token());
                }
                usedLabelNames.put(labels[i].toString(), labels[i]);
            }
        }
        usedLabelNames.clear();
        this.ts.parse();
        this.myUnion.addImportedName(this.ts.typeName());
    }

    public void print(PrintWriter ps) {
        Enumeration e = this.caseListVector.elements();
        while (e.hasMoreElements()) {
            Case c = (Case)e.nextElement();
            c.print(ps);
        }
    }
}

