/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.jacorb.idl.ConstDecl;
import org.jacorb.idl.ConstrTypeSpec;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.Interface;
import org.jacorb.idl.NameTable;
import org.jacorb.idl.SimpleTypeSpec;
import org.jacorb.idl.SwitchTypeSpec;
import org.jacorb.idl.TypeMap;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.lexer;
import org.jacorb.idl.parser;

public class ScopedName
extends SimpleTypeSpec
implements SwitchTypeSpec {
    private static Hashtable pseudoScopes = new Hashtable();
    private static Hashtable enumMap = new Hashtable();
    private static Stack recursionStack = new Stack();
    private TypeSpec resolvedSpec = null;
    private String resolvedName = null;
    private boolean resolved = false;
    private Interface resolvedInterface = null;
    boolean set = false;
    public String typeName = null;

    public static void definePseudoScope(String name) {
        pseudoScopes.put(name, "");
    }

    public static boolean isPseudoScope(String name) {
        return pseudoScopes.containsKey(name);
    }

    public static String unPseudoName(String name) {
        String n = ScopedName.unPseudo(name);
        if (n.endsWith("PackagePackage") || !n.startsWith("_") && n.endsWith("Package")) {
            n = n.substring(0, n.lastIndexOf("Package"));
        }
        return n;
    }

    private static String unPseudo(String name) {
        if (name.charAt(0) == '.') {
            name = name.substring(1);
        }
        String head = name;
        String tail = null;
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        while (!ScopedName.isPseudoScope(head)) {
            lastDot = head.lastIndexOf(46);
            if (lastDot < 0) {
                return name;
            }
            head = name.substring(0, lastDot);
            tail = name.substring(lastDot + 1);
        }
        StringTokenizer strtok = new StringTokenizer(head, ".");
        String[] scopes = new String[strtok.countTokens()];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            scopes[i++] = strtok.nextToken();
        }
        StringBuffer newHead = new StringBuffer();
        int j = 1;
        newHead.append(scopes[0]);
        while (!ScopedName.isPseudoScope(newHead.toString())) {
            if (j == scopes.length) {
                return name;
            }
            newHead.append(".");
            newHead.append(scopes[j++]);
        }
        StringBuffer copy = new StringBuffer(newHead.toString());
        newHead.append("Package");
        while (j < scopes.length) {
            newHead.append("." + scopes[j]);
            copy.append("." + scopes[j]);
            if (ScopedName.isPseudoScope(copy.toString())) {
                newHead.append("Package");
            }
            ++j;
        }
        if (tail != null) {
            newHead.append("." + tail);
        }
        return newHead.toString();
    }

    public static void enumMap(String n, String m) {
        enumMap.put(n, m);
    }

    private static String unEnum(String _name) {
        String n = (String)enumMap.get(_name);
        if (n != null) {
            return n;
        }
        return _name;
    }

    public ScopedName(int num) {
        super(num);
    }

    public Object clone() {
        ScopedName sn = new ScopedName(ScopedName.new_num());
        sn.resolvedSpec = this.resolvedSpec;
        sn.resolvedName = this.resolvedName;
        sn.resolved = this.resolved;
        sn.typeName = this.typeName;
        sn.token = this.token;
        sn.set = this.set;
        sn.pack_name = this.pack_name;
        sn.name = this.name;
        sn.is_pseudo = this.is_pseudo;
        sn.included = this.included;
        sn.inhibitionFlag = this.inhibitionFlag;
        return sn;
    }

    public void setId(String _id) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScopedName.setId " + _id);
        }
        this.typeName = _id;
        this.escapeName();
    }

    public void escapeName() {
        if (!this.isEscaped(this.typeName)) {
            if (this.typeName.indexOf(46) > -1) {
                if (lexer.strictJavaEscapeCheck(this.typeName.substring(this.typeName.lastIndexOf(46) + 1))) {
                    this.typeName = this.typeName.substring(0, this.typeName.lastIndexOf(46) + 1) + "_" + this.typeName.substring(this.typeName.lastIndexOf(46) + 1);
                }
            } else if (lexer.strictJavaEscapeCheck(this.typeName)) {
                this.typeName = "_" + this.typeName;
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScopedName.escapeName " + this.typeName);
        }
    }

    public void setEnclosingSymbol(IdlSymbol s) {
        if (this.enclosing_symbol != null && this.enclosing_symbol != s) {
            throw new RuntimeException("Compiler Error: trying to reassign container for " + this.name);
        }
        this.enclosing_symbol = s;
    }

    public void parse() {
    }

    public boolean resolved() {
        return this.resolved;
    }

    public boolean basic() {
        TypeSpec t = this.resolvedTypeSpec();
        return t.basic();
    }

    public boolean is_pseudo() {
        return NameTable.isDefined(this.resolvedName(), "pseudo interface");
    }

    public TypeSpec resolvedTypeSpec() {
        if (!this.resolved) {
            this.resolvedName = this.resolvedName();
        }
        if (this.resolvedSpec == null) {
            parser.fatal_error("Not a type: " + this.resolvedName, this.token);
        }
        return this.resolvedSpec;
    }

    public boolean isEscaped(String name) {
        String last = null;
        last = name.indexOf(46) > -1 ? name.substring(name.lastIndexOf(46) + 1) : name;
        return last.startsWith("_");
    }

    public String resolvedName() {
        ConstDecl constDecl;
        if (!this.resolved) {
            this.resolvedName = this.resolvedName(this.pack_name, this.typeName);
        }
        if ((constDecl = ConstDecl.getDeclaration(this.resolvedName)) != null && !constDecl.contained()) {
            this.resolvedName = this.resolvedName + ".value";
        }
        this.resolved = true;
        return this.resolvedName;
    }

    private String resolvedName(String scopeOfOrigin, String name) {
        int k;
        int i;
        String replacedPackageName;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Resolve " + scopeOfOrigin + ":" + name);
        }
        if (name == null) {
            throw new RuntimeException("Parser Error: null string in ScopedName (pack_name: " + scopeOfOrigin + ") !");
        }
        String result = null;
        boolean global = false;
        if (name.charAt(0) == '.') {
            name = name.substring(1);
            global = true;
        }
        String bracketSuffix = "";
        if (name.endsWith("[]")) {
            result = name.substring(0, name.indexOf("["));
            bracketSuffix = "[]";
        } else {
            result = name;
        }
        if (!global && NameTable.isDefined(scopeOfOrigin + "." + result)) {
            String unmappedResult = this.unMap(scopeOfOrigin + "." + result);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("resolve, " + scopeOfOrigin + "." + result + " was in name table, returning " + unmappedResult + " suffix: " + bracketSuffix);
            }
            return unmappedResult + bracketSuffix;
        }
        if ((global || result.indexOf(46) > -1) && NameTable.isDefined(result)) {
            String unmappedResult = this.unMap(result);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("resolve, found " + result + " in name table, returning " + unmappedResult + " suffix: " + bracketSuffix);
            }
            return unmappedResult + bracketSuffix;
        }
        StringTokenizer strtok = new StringTokenizer(name, ".");
        String[] nameScopes = new String[strtok.countTokens()];
        int i2 = 0;
        while (strtok.hasMoreTokens()) {
            nameScopes[i2] = strtok.nextToken();
            ++i2;
        }
        if (nameScopes.length > 0 && !(replacedPackageName = parser.pack_replace(nameScopes[0])).equals(nameScopes[0])) {
            StringBuffer tmpString = new StringBuffer();
            tmpString.append(replacedPackageName);
            for (i = 1; i < nameScopes.length; ++i) {
                tmpString.append(".");
                tmpString.append(nameScopes[i]);
            }
            result = tmpString.toString();
            if (NameTable.isDefined(result)) {
                String unmappedResult = this.unMap(result);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("resolve b, " + result + " was in name table, returning " + unmappedResult + " suffix: " + bracketSuffix);
                }
                return unmappedResult + bracketSuffix;
            }
        }
        StringTokenizer p_strtok = new StringTokenizer(scopeOfOrigin, ".");
        String[] packageScopes = new String[p_strtok.countTokens()];
        i = 0;
        while (p_strtok.hasMoreTokens()) {
            packageScopes[i] = p_strtok.nextToken();
            ++i;
        }
        if (nameScopes.length == 0 || packageScopes.length == 0) {
            if (NameTable.isDefined(result)) {
                return this.unMap(result) + bracketSuffix;
            }
            parser.fatal_error("Undefined name: " + name + " .", this.token);
        }
        if (nameScopes[0].equals(packageScopes[0])) {
            int minScopesLength;
            StringBuffer tmpString = new StringBuffer();
            int n = minScopesLength = nameScopes.length < packageScopes.length ? nameScopes.length : packageScopes.length;
            if (minScopesLength > 1) {
                int i3;
                for (i3 = 1; i3 < minScopesLength - 1 && nameScopes[i3].equals(packageScopes[i3]); ++i3) {
                }
                tmpString.append(nameScopes[i3]);
                for (k = i3 + 1; k < nameScopes.length; ++k) {
                    tmpString.append(".");
                    tmpString.append(nameScopes[k]);
                }
                name = tmpString.toString();
            }
        }
        String prefix = "";
        int start_index = 0;
        if (parser.package_prefix != null) {
            prefix = parser.package_prefix + ".";
            StringTokenizer prefix_strtok = new StringTokenizer(prefix, ".");
            String[] prefix_scopes = new String[prefix_strtok.countTokens()];
            int i4 = 0;
            while (prefix_strtok.hasMoreTokens()) {
                prefix_scopes[i4] = prefix_strtok.nextToken();
                ++i4;
            }
            while (start_index < prefix_scopes.length && prefix_scopes[start_index].equals(packageScopes[start_index])) {
                ++start_index;
            }
        }
        StringBuffer buf = new StringBuffer();
        k = packageScopes.length - start_index;
        if (k > 0) {
            buf.append(packageScopes[start_index] + ".");
        }
        for (int j = start_index + 1; j < packageScopes.length; ++j) {
            buf.append(packageScopes[j]);
            buf.append(".");
        }
        buf.append(name);
        int sub = start_index + 1;
        while (!NameTable.isDefined(prefix + buf.toString())) {
            if (sub > packageScopes.length) {
                parser.fatal_error("Undefined name: " + scopeOfOrigin + "." + name, this.token);
                return "/* unresolved name */";
            }
            buf = new StringBuffer();
            if ((k = packageScopes.length - sub++) > 0) {
                buf.append(packageScopes[start_index] + ".");
                for (int j = start_index + 1; j < k + start_index; ++j) {
                    buf.append(packageScopes[j]);
                    buf.append(".");
                }
            }
            buf.append(name);
        }
        String res = this.unMap(prefix + buf.toString()) + bracketSuffix;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.resolve (at end) returns: " + res);
        }
        return res;
    }

    public TypeSpec typeSpec() {
        return this;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.set = true;
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
    }

    private String qualify(String str) {
        if (str.charAt(0) == '.') {
            return str.substring(1);
        }
        if (!this.pack_name.equals("")) {
            return this.pack_name + "." + str;
        }
        return str;
    }

    private String unMap(String _name) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.unmap: " + _name);
        }
        Object tmp = null;
        TypeSpec y = TypeMap.map(_name);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ScopedName.unmap: " + _name + ", Type.map( " + _name + " ) is : " + y);
        }
        TypeSpec x = null;
        while (!(y == null || y instanceof ScopedName || y instanceof ConstrTypeSpec || (x = y).equals(y = y.typeSpec()))) {
        }
        if (y == null) {
            if (x != null) {
                this.resolvedSpec = x;
                return x.typeName();
            }
            this.resolvedSpec = y;
            return ScopedName.unEnum(_name);
        }
        if (y instanceof ConstrTypeSpec) {
            this.resolvedSpec = y;
            return y.typeName();
        }
        if (y instanceof ScopedName && y != null && x != y) {
            return this.unMap(y.typeName());
        }
        if (y == null) {
            this.resolvedSpec = x;
            return x.typeName();
        }
        this.resolvedSpec = y;
        return _name;
    }

    public String typeName() {
        String n = ScopedName.unPseudo(this.resolvedName(this.pack_name, this.typeName));
        if (n.endsWith("PackagePackage") || !this.isEscaped(n) && n.endsWith("Package")) {
            n = n.substring(0, n.lastIndexOf("Package"));
        }
        return n;
    }

    public String holderName() {
        return this.resolvedTypeSpec().holderName();
    }

    public String printReadExpression(String streamname) {
        return this.resolvedTypeSpec().printReadExpression(streamname);
    }

    public String printWriteStatement(String var_name, String streamname) {
        return this.resolvedTypeSpec().printWriteStatement(var_name, streamname);
    }

    public String printInsertExpression() {
        return this.resolvedTypeSpec().printInsertExpression();
    }

    public String printExtractExpression() {
        return this.resolvedTypeSpec().printExtractExpression();
    }

    public String getTypeCodeExpression() {
        return this.resolvedTypeSpec().getTypeCodeExpression();
    }

    public String id() {
        return this.resolvedTypeSpec().id();
    }

    public String toString() {
        String n = this.typeName();
        if (this.resolvedTypeSpec() != null && !n.startsWith("org.omg")) {
            n = this.resolvedTypeSpec().omgPrefix() + n;
        }
        return n;
    }

    public void print(PrintWriter ps) {
    }

    public String IDLName() {
        String n = this.toString();
        StringBuffer sb = new StringBuffer();
        int from = 0;
        while (n.substring(from).indexOf(46) > 0) {
            int to = from + n.substring(from).indexOf(46);
            sb.append(n.substring(from, to) + "::");
            from = to + 1;
        }
        sb.append(n.substring(from));
        return sb.toString();
    }

    public static void addRecursionScope(String typeName) {
        recursionStack.push(typeName);
    }

    public static void removeRecursionScope(String typeName) {
        String check = (String)recursionStack.pop();
        if (!(typeName == null || check != null && check.equals(typeName))) {
            throw new RuntimeException("RecursionScope Error, expected " + typeName + ", got " + check);
        }
    }

    public static boolean isRecursionScope(String typeName) {
        return recursionStack.search(typeName) != -1;
    }

    public boolean isSwitchable() {
        TypeSpec t = this.resolvedTypeSpec();
        return t instanceof SwitchTypeSpec && ((SwitchTypeSpec)((Object)t)).isSwitchable();
    }
}

