/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.idl;

import java.io.PrintWriter;
import org.jacorb.idl.IDLTreeVisitor;
import org.jacorb.idl.IdlSymbol;
import org.jacorb.idl.ParseException;
import org.jacorb.idl.ScopedName;
import org.jacorb.idl.SimpleDeclarator;
import org.jacorb.idl.TypeSpec;
import org.jacorb.idl.parser;

public class ParamDecl
extends IdlSymbol {
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    public static final int MODE_INOUT = 3;
    public int paramAttribute;
    public TypeSpec paramTypeSpec;
    public SimpleDeclarator simple_declarator;

    public ParamDecl(int num) {
        super(num);
    }

    public ParamDecl(int paramAttribute, TypeSpec paramTypeSpec, SimpleDeclarator simple_declarator) {
        super(ParamDecl.new_num());
        this.paramAttribute = paramAttribute;
        this.paramTypeSpec = paramTypeSpec;
        this.simple_declarator = simple_declarator;
    }

    public ParamDecl(int paramAttribute, TypeSpec paramTypeSpec, String name) {
        super(ParamDecl.new_num());
        this.paramAttribute = paramAttribute;
        this.paramTypeSpec = paramTypeSpec;
        this.simple_declarator = new SimpleDeclarator(ParamDecl.new_num());
        this.simple_declarator.name = name;
    }

    public void setPackage(String s) {
        s = parser.pack_replace(s);
        this.pack_name = this.pack_name.length() > 0 ? s + "." + this.pack_name : s;
        this.paramTypeSpec.setPackage(s);
    }

    public ParamDecl asIn() {
        return new ParamDecl(1, this.paramTypeSpec, this.simple_declarator);
    }

    public void parse() {
        while (this.paramTypeSpec.typeSpec() instanceof ScopedName) {
            TypeSpec ts = ((ScopedName)this.paramTypeSpec.typeSpec()).resolvedTypeSpec();
            if (ts == null) continue;
            this.paramTypeSpec = ts;
        }
        if (this.paramTypeSpec == null) {
            throw new ParseException("parameter TypeSpec is null " + this.name, this.myPosition);
        }
    }

    public void print(PrintWriter ps) {
        switch (this.paramAttribute) {
            case 1: {
                ps.print(this.paramTypeSpec.toString());
                break;
            }
            case 2: 
            case 3: {
                ps.print(this.paramTypeSpec.holderName());
            }
        }
        ps.print(" " + this.simple_declarator);
    }

    public String printWriteStatement(String ps) {
        return this.printWriteStatement(this.simple_declarator.toString(), ps);
    }

    public String printWriteStatement(String name, String ps) {
        if (this.paramAttribute != 1) {
            return this.paramTypeSpec.typeSpec().printWriteStatement(name + ".value", ps);
        }
        return this.paramTypeSpec.typeSpec().printWriteStatement(name, ps);
    }

    public String printReadExpression(String ps) {
        return this.paramTypeSpec.typeSpec().printReadExpression(ps);
    }

    public void printAddArgumentStatement(PrintWriter ps, String reqname) {
        String varname = this.simple_declarator.toString();
        String anyname = "$" + varname;
        ps.print("\t\torg.omg.CORBA.Any " + anyname + " = " + reqname);
        switch (this.paramAttribute) {
            case 2: {
                ps.println(".add_out_arg();");
                varname = varname + ".value";
                break;
            }
            case 1: {
                ps.println(".add_in_arg();");
                break;
            }
            case 3: {
                ps.println(".add_inout_arg();");
                varname = varname + ".value";
                break;
            }
            default: {
                throw new ParseException("Wrong parameter declaration");
            }
        }
        this.paramTypeSpec.typeSpec().printInsertIntoAny(ps, anyname, varname);
    }

    public void printExtractArgumentStatement(PrintWriter ps) {
        String varname = this.simple_declarator.toString();
        String anyname = "$" + varname;
        this.paramTypeSpec.typeSpec().printExtractResult(ps, varname + ".value", anyname, this.paramTypeSpec.toString());
    }

    public void accept(IDLTreeVisitor visitor) {
        visitor.visitParamDecl(this);
    }
}

