/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.Preference;
import org.jacorb.trading.constraint.PropertySchema;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkImpl;
import org.jacorb.trading.impl.OfferEvaluator;
import org.jacorb.trading.impl.OfferIteratorImpl;
import org.jacorb.trading.impl.ProxySourceAdapter;
import org.jacorb.trading.impl.SchemaAdapter;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.jacorb.trading.util.PropUtil;
import org.jacorb.trading.util.QueryContainer;
import org.jacorb.trading.util.QueryPropagator;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.FollowOptionHelper;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupPOA;
import org.omg.CosTrading.LookupPackage.IllegalPolicyName;
import org.omg.CosTrading.LookupPackage.IllegalPreference;
import org.omg.CosTrading.LookupPackage.InvalidPolicyValue;
import org.omg.CosTrading.LookupPackage.PolicyTypeMismatch;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIterator;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class LookupImpl
extends LookupPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private ImportAttrib m_import;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private LinkImpl m_link_if;
    private static int m_query_counter;
    private Hashtable m_query_cache_lookup;
    private Vector m_query_cache_queue;
    private int m_query_cache_max = 100;
    private QueryPropagator m_query_distrib;
    private LinkInfo[] m_links_cache;
    private static int count;
    private Logger logger;

    private LookupImpl() {
    }

    public LookupImpl(TraderComp traderComp, SupportAttrib supportAttrib, ImportAttrib importAttrib, OfferDatabase offerDatabase, LinkImpl linkImpl, Configuration configuration) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_import = importAttrib;
        this.m_db = offerDatabase;
        Object object = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(object);
        this.logger = configuration.getNamedLogger("jacorb.trading");
        this.m_query_cache_max = configuration.getAttributeAsInteger("jtrader.impl.cache_max", 100);
        this.m_link_if = linkImpl;
        this.m_query_cache_lookup = new Hashtable((int)(1.3333333333333333 * (double)this.m_query_cache_max) + 10);
        this.m_query_cache_queue = new Vector(this.m_query_cache_max + 2);
        this.m_query_distrib = new QueryPropagator();
        try {
            this.m_query_distrib.configure(configuration);
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("ConfigurationException", (Throwable)configurationException);
            throw new INITIALIZE(configurationException.getMessage());
        }
    }

    public String _object_name() {
        return "TradingService";
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public int def_search_card() {
        return this.m_import.getDefSearchCard();
    }

    public int max_search_card() {
        return this.m_import.getMaxSearchCard();
    }

    public int def_match_card() {
        return this.m_import.getDefMatchCard();
    }

    public int max_match_card() {
        return this.m_import.getMaxMatchCard();
    }

    public int def_return_card() {
        return this.m_import.getDefReturnCard();
    }

    public int max_return_card() {
        return this.m_import.getMaxReturnCard();
    }

    public int max_list() {
        return this.m_import.getMaxList();
    }

    public int def_hop_count() {
        return this.m_import.getDefHopCount();
    }

    public int max_hop_count() {
        return this.m_import.getMaxHopCount();
    }

    public FollowOption def_follow_policy() {
        return this.m_import.getDefFollowPolicy();
    }

    public FollowOption max_follow_policy() {
        return this.m_import.getMaxFollowPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String string, String string2, String string3, Policy[] policyArray, SpecifiedProps specifiedProps, int n, OfferSeqHolder offerSeqHolder, OfferIteratorHolder offerIteratorHolder, PolicyNameSeqHolder policyNameSeqHolder) throws IllegalServiceType, UnknownServiceType, IllegalConstraint, IllegalPreference, IllegalPolicyName, PolicyTypeMismatch, InvalidPolicyValue, IllegalPropertyName, DuplicatePropertyName, DuplicatePolicyName {
        int n2;
        java.lang.Object object;
        Policy[] policyArray2;
        int n3 = count++;
        TypeStruct typeStruct = this.m_repos.fully_describe_type(string);
        Hashtable<String, Any> hashtable = new Hashtable<String, Any>();
        for (int i = 0; i < policyArray.length; ++i) {
            if (hashtable.containsKey(policyArray[i].name)) {
                throw new DuplicatePolicyName(policyArray[i].name);
            }
            hashtable.put(policyArray[i].name, policyArray[i].value);
        }
        String string4 = this.getPolicyValue(hashtable, "request_id", new String());
        Vector<java.lang.Object> vector = new Vector<java.lang.Object>();
        if (string4.length() == 0) {
            policyArray2 = new StringBuffer(new String(this.admin_if().request_id_stem()));
            policyArray2.append(m_query_counter++);
            object = new Policy();
            ((Policy)object).name = "request_id";
            ((Policy)object).value = this._orb().create_any();
            ((Policy)object).value.insert_string(policyArray2.toString());
            vector.addElement(object);
            string4 = policyArray2.toString();
        }
        if (this.queryAlreadyEncountered(string4)) {
            offerSeqHolder.value = new Offer[0];
            policyNameSeqHolder.value = new String[0];
            return;
        }
        if (!hashtable.containsKey("hop_count")) {
            policyArray2 = new Policy();
            policyArray2.name = "hop_count";
            policyArray2.value = this._orb().create_any();
            policyArray2.value.insert_ulong(this.def_hop_count());
            vector.addElement(policyArray2);
            hashtable.put("hop_count", policyArray2.value);
        }
        if (vector.size() > 0) {
            policyArray2 = new Policy[policyArray.length + vector.size()];
            System.arraycopy(policyArray, 0, policyArray2, 0, policyArray.length);
            object = vector.elements();
            n2 = policyArray.length;
            while (object.hasMoreElements()) {
                policyArray2[n2++] = (Policy)object.nextElement();
            }
            policyArray = policyArray2;
        }
        int n4 = this.getPolicyValue(hashtable, "search_card", this.def_search_card(), this.max_search_card());
        int n5 = this.getPolicyValue(hashtable, "match_card", this.def_match_card(), this.max_match_card());
        n2 = this.getPolicyValue(hashtable, "return_card", this.def_return_card(), this.max_return_card());
        boolean bl = this.getPolicyValue(hashtable, "exact_type_match", false);
        boolean bl2 = !this.supports_dynamic_properties() ? false : this.getPolicyValue(hashtable, "use_dynamic_properties", true);
        boolean bl3 = !this.supports_modifiable_properties() ? false : this.getPolicyValue(hashtable, "use_modifiable_properties", true);
        boolean bl4 = !this.supports_proxy_offers() ? false : this.getPolicyValue(hashtable, "use_proxy_offers", true);
        FollowOption followOption = this.getPolicyValue(hashtable, "link_follow_rule", this.def_follow_policy(), this.max_follow_policy());
        int n6 = this.getPolicyValue(hashtable, "hop_count", this.def_hop_count(), this.max_hop_count());
        Any any = (Any)hashtable.get("hop_count");
        any.insert_ulong(any.extract_ulong() - 1);
        QueryContainer queryContainer = new QueryContainer(string, string2, string3, policyArray, specifiedProps, n, null);
        Vector vector2 = new Vector();
        Hashtable hashtable2 = new Hashtable();
        if (n6 > 0 && followOption.value() == FollowOption.always.value()) {
            this.distributeQuery(vector2, queryContainer, followOption, hashtable2);
        }
        if (string3 == null || string3.trim().length() == 0) {
            string3 = "first";
        }
        SchemaAdapter schemaAdapter = new SchemaAdapter(typeStruct);
        Constraint constraint = new Constraint((PropertySchema)schemaAdapter);
        Preference preference = new Preference((PropertySchema)schemaAdapter);
        try {
            constraint.parse(string2);
        }
        catch (ParseException parseException) {
            System.out.println("Illegal constraint '" + string2 + "'");
            System.out.println(parseException.getMessage());
            throw new IllegalConstraint(string2);
        }
        try {
            preference.parse(string3);
        }
        catch (ParseException parseException) {
            System.out.println("Illegal preference '" + string3 + "'");
            System.out.println(parseException.getMessage());
            throw new IllegalPreference(string3);
        }
        Vector<String> vector3 = new Vector<String>();
        vector3.addElement(string);
        if (!bl) {
            this.findCompatibleTypes(string, vector3);
        }
        try {
            java.lang.Object object2;
            int n7;
            int n8;
            Serializable serializable;
            java.lang.Object object3;
            Serializable serializable2;
            Enumeration<java.lang.Object> enumeration;
            Cloneable cloneable;
            java.lang.Object object4;
            this.m_db.begin(0);
            int n9 = 0;
            Vector<java.lang.Object> vector4 = new Vector<java.lang.Object>();
            Enumeration enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements() && n9 < n4) {
                object4 = (String)enumeration2.nextElement();
                cloneable = this.m_db.getOffers((String)object4);
                if (cloneable == null) continue;
                enumeration = ((Hashtable)cloneable).elements();
                while (enumeration.hasMoreElements() && n9 < n4) {
                    serializable2 = (OfferInfo)enumeration.nextElement();
                    object3 = new SourceAdapter(((OfferInfo)serializable2).reference, ((OfferInfo)serializable2).properties);
                    if (!this.considerOffer((SourceAdapter)object3, bl2, bl3, typeStruct)) continue;
                    vector4.addElement(object3);
                    ++n9;
                }
            }
            if (bl4) {
                enumeration2 = vector3.elements();
                while (enumeration2.hasMoreElements() && n9 < n4) {
                    object4 = (String)enumeration2.nextElement();
                    cloneable = this.m_db.getProxyOffers((String)object4);
                    if (cloneable == null) continue;
                    enumeration = ((Hashtable)cloneable).elements();
                    while (enumeration.hasMoreElements() && n9 < n4) {
                        serializable2 = (ProxyInfo)enumeration.nextElement();
                        object3 = new ProxySourceAdapter((ProxyInfo)serializable2);
                        if (!this.considerOffer((SourceAdapter)object3, bl2, bl3, typeStruct)) continue;
                        vector4.addElement(object3);
                        ++n9;
                    }
                }
            }
            if (((Vector)(cloneable = ((OfferEvaluator)(object4 = new OfferEvaluator(string, constraint, string3, policyArray, specifiedProps, vector4, n5))).getResults())).size() == 0 && n6 > 0 && followOption.value() >= FollowOption.if_no_local.value()) {
                this.distributeQuery(vector2, queryContainer, followOption, hashtable2);
            }
            enumeration = vector2.elements();
            serializable2 = new Vector();
            object3 = new Vector();
            while (enumeration.hasMoreElements()) {
                QueryContainer queryContainer2 = (QueryContainer)enumeration.nextElement();
                try {
                    queryContainer2.resultReady();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                serializable = queryContainer2.getException();
                if (serializable != null) {
                    ((Vector)serializable2).addElement(queryContainer2);
                    continue;
                }
                OfferSeqHolder offerSeqHolder2 = queryContainer2.getOffers();
                if (offerSeqHolder2.value == null || offerSeqHolder2.value.length == 0) {
                    ((Vector)serializable2).addElement(queryContainer2);
                    continue;
                }
                for (int i = 0; i < offerSeqHolder2.value.length; ++i) {
                    ((Vector)cloneable).addElement(offerSeqHolder2.value[i]);
                }
                PolicyNameSeqHolder policyNameSeqHolder2 = queryContainer2.getLimits();
                if (policyNameSeqHolder2.value == null) continue;
                for (n8 = 0; n8 < policyNameSeqHolder2.value.length; ++n8) {
                    ((Vector)object3).addElement(policyNameSeqHolder2.value[n8]);
                }
            }
            for (n7 = 0; n7 < ((Vector)serializable2).size(); ++n7) {
                vector2.removeElement(((Vector)serializable2).elementAt(n7));
            }
            n7 = ((Vector)cloneable).size();
            serializable = preference.order((Vector)cloneable);
            int n10 = Math.min(n7, n2);
            int n11 = Math.min(n10, n);
            offerSeqHolder.value = new Offer[n11];
            enumeration2 = ((Vector)serializable).elements();
            for (n8 = 0; enumeration2.hasMoreElements() && n8 < n11; ++n8) {
                java.lang.Object e = enumeration2.nextElement();
                if (e instanceof Offer) {
                    offerSeqHolder.value[n8] = (Offer)e;
                    continue;
                }
                object2 = (SourceAdapter)e;
                offerSeqHolder.value[n8] = new Offer();
                offerSeqHolder.value[n8].reference = ((SourceAdapter)object2).getObject();
                offerSeqHolder.value[n8].properties = ((SourceAdapter)object2).getProperties(specifiedProps);
            }
            if (n11 < n10) {
                Offer[] offerArray;
                java.lang.Object object5;
                java.lang.Object object6;
                int n12;
                int n13 = n10 - n11;
                object2 = new Vector(n13);
                for (n12 = 0; enumeration2.hasMoreElements() && n12 < n13; ++n12) {
                    object6 = enumeration2.nextElement();
                    if (object6 instanceof Offer) {
                        ((Vector)object2).addElement(object6);
                        continue;
                    }
                    object5 = (Offer[])object6;
                    offerArray = new Offer();
                    offerArray.reference = ((SourceAdapter)object5).getObject();
                    offerArray.properties = ((SourceAdapter)object5).getProperties(specifiedProps);
                    ((Vector)object2).addElement(offerArray);
                }
                enumeration = vector2.elements();
                while (n12 < n13 && enumeration.hasMoreElements()) {
                    ++n12;
                    object6 = (QueryContainer)enumeration.nextElement();
                    object5 = ((QueryContainer)object6).getItr();
                    if (((OfferIteratorHolder)object5).value == null) continue;
                    offerArray = null;
                    try {
                        offerArray = ((OfferIteratorImpl)((java.lang.Object)((OfferIteratorHolder)object5).value)).getOffers();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (offerArray == null) {
                        OfferIterator offerIterator = ((OfferIteratorHolder)object5).value;
                        OfferSeqHolder offerSeqHolder3 = new OfferSeqHolder();
                        offerIterator.next_n(n13 - n12, offerSeqHolder3);
                        offerArray = offerSeqHolder3.value;
                    }
                    int n14 = 0;
                    while (n14 < offerArray.length && n12 < n13) {
                        ++n12;
                        ((Vector)object2).addElement(offerArray[n14++]);
                    }
                }
                object6 = ((Vector)object2).elements();
                object5 = new Offer[((Vector)object2).size()];
                int n15 = 0;
                while (object6.hasMoreElements()) {
                    object5[n15++] = (Offer)object6.nextElement();
                }
                OfferIteratorImpl offerIteratorImpl = new OfferIteratorImpl((Offer[])object5, 0);
                offerIteratorImpl._this_object(this._orb());
                offerIteratorHolder.value = offerIteratorImpl._this();
            }
            Enumeration enumeration3 = ((Vector)object3).elements();
            policyNameSeqHolder.value = new String[((Vector)object3).size()];
            int n16 = 0;
            while (enumeration3.hasMoreElements()) {
                policyNameSeqHolder.value[n16++] = (String)enumeration3.nextElement();
            }
        }
        finally {
            this.m_db.end();
        }
    }

    private boolean queryAlreadyEncountered(String string) {
        boolean bl = this.m_query_cache_lookup.containsKey(string);
        if (!bl) {
            this.m_query_cache_lookup.put(string, string);
            this.m_query_cache_queue.addElement(string);
            if (this.m_query_cache_queue.size() > this.m_query_cache_max) {
                java.lang.Object e = this.m_query_cache_queue.firstElement();
                this.m_query_cache_queue.removeElementAt(0);
                this.m_query_cache_lookup.remove(e);
            }
        }
        return bl;
    }

    protected FollowOption getPolicyValue(Hashtable hashtable, String string, FollowOption followOption, FollowOption followOption2) throws PolicyTypeMismatch, InvalidPolicyValue {
        FollowOption followOption3 = followOption;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                TypeCode typeCode = FollowOptionHelper.type();
                if (!typeCode.equal(any.type())) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                followOption3 = FollowOptionHelper.extract(any);
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return FollowOption.from_int(Math.min(followOption3.value(), followOption2.value()));
    }

    private void updateLinks() {
        if (this.m_link_if.linksChanged()) {
            this.m_links_cache = this.m_link_if.getLinks();
        }
    }

    private void distributeQuery(Vector vector, QueryContainer queryContainer, FollowOption followOption, Hashtable hashtable) {
        this.updateLinks();
        LinkInfo[] linkInfoArray = this.m_links_cache;
        for (int i = 0; i < linkInfoArray.length; ++i) {
            if (linkInfoArray[i].limiting_follow_rule.value() < followOption.value() || hashtable.containsKey(linkInfoArray[i].target)) continue;
            QueryContainer queryContainer2 = new QueryContainer(queryContainer, linkInfoArray[i].target);
            vector.addElement(queryContainer2);
            this.m_query_distrib.putWork(queryContainer2);
            hashtable.put(linkInfoArray[i].target, linkInfoArray[i].target);
        }
    }

    protected int getPolicyValue(Hashtable hashtable, String string, int n, int n2) throws PolicyTypeMismatch, InvalidPolicyValue {
        int n3 = n;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_ulong) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                n3 = any.extract_ulong();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        n3 = Math.min(n3, n2);
        return n3;
    }

    protected boolean getPolicyValue(Hashtable hashtable, String string, boolean bl) throws PolicyTypeMismatch, InvalidPolicyValue {
        boolean bl2 = bl;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_boolean) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                bl2 = any.extract_boolean();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return bl2;
    }

    protected String getPolicyValue(Hashtable hashtable, String string, String string2) throws PolicyTypeMismatch, InvalidPolicyValue {
        String string3 = string2;
        Any any = (Any)hashtable.get(string);
        if (any != null) {
            try {
                if (any.type().kind() != TCKind.tk_string) {
                    throw new PolicyTypeMismatch(new Policy(string, any));
                }
                string3 = any.extract_string();
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                throw new InvalidPolicyValue(new Policy(string, any));
            }
        }
        return string3;
    }

    protected void findCompatibleTypes(String string, Vector vector) {
        SpecifiedServiceTypes specifiedServiceTypes = new SpecifiedServiceTypes();
        specifiedServiceTypes.__default();
        String[] stringArray = this.m_repos.list_types(specifiedServiceTypes);
        block3: for (int i = 0; i < stringArray.length; ++i) {
            try {
                TypeStruct typeStruct = this.m_repos.fully_describe_type(stringArray[i]);
                for (int j = 0; j < typeStruct.super_types.length; ++j) {
                    if (!string.equals(typeStruct.super_types[j])) continue;
                    if (vector.contains(stringArray[i])) continue block3;
                    vector.addElement(stringArray[i]);
                    continue block3;
                }
                continue;
            }
            catch (IllegalServiceType illegalServiceType) {
                continue;
            }
            catch (UnknownServiceType unknownServiceType) {
                // empty catch block
            }
        }
    }

    protected boolean considerOffer(SourceAdapter sourceAdapter, boolean bl, boolean bl2, TypeStruct typeStruct) {
        Property[] propertyArray;
        if (!bl && PropUtil.hasDynamicProperties(propertyArray = sourceAdapter.getProperties())) {
            return false;
        }
        if (!bl2) {
            for (int i = 0; i < typeStruct.props.length; ++i) {
                if (typeStruct.props[i].mode != PropertyMode.PROP_NORMAL && typeStruct.props[i].mode != PropertyMode.PROP_MANDATORY || !sourceAdapter.exists(typeStruct.props[i].name)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        count = 0;
    }
}

