/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.factory.SocketFactory;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.orb.iiop.IIOPLoopback;
import org.jacorb.orb.iiop.IIOPLoopbackInputStream;
import org.jacorb.orb.iiop.IIOPLoopbackOutputStream;
import org.jacorb.orb.iiop.IIOPLoopbackRegistry;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.ETF.Profile;
import org.omg.SSLIOP.SSL;

public class ClientIIOPConnection
extends IIOPConnection
implements Configurable {
    private int timeout = 0;
    private int ssl_port = -1;
    private int noOfRetries = 5;
    private int retryInterval = 0;
    private boolean doSupportSSL = false;
    private TransportManager transportManager;
    public static int openTransports = 0;
    private Exception exception = null;
    static /* synthetic */ Class class$org$omg$CSIIOP$CompoundSecMechListHelper;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public ClientIIOPConnection() {
        this.use_ssl = false;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.idle_timeout", 0);
        this.noOfRetries = configuration.getAttributeAsInteger("jacorb.retries", 5);
        this.retryInterval = configuration.getAttributeAsInteger("jacorb.retry_interval", 500);
        this.doSupportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.transportManager = this.configuration.getORB().getTransportManager();
    }

    public ClientIIOPConnection(ClientIIOPConnection clientIIOPConnection) {
        super(clientIIOPConnection);
        this.timeout = clientIIOPConnection.timeout;
        this.ssl_port = clientIIOPConnection.ssl_port;
    }

    public synchronized void connect(Profile profile, long l) {
        if (!this.connected) {
            if (!(profile instanceof IIOPProfile)) {
                throw new BAD_PARAM("attempt to connect an IIOP connection to a non-IIOP profile: " + profile.getClass());
            }
            this.profile = (IIOPProfile)profile;
            IIOPLoopback iIOPLoopback = this.getLocalLoopback();
            if (iIOPLoopback != null) {
                IIOPLoopbackInputStream iIOPLoopbackInputStream = new IIOPLoopbackInputStream();
                IIOPLoopbackOutputStream iIOPLoopbackOutputStream = new IIOPLoopbackOutputStream();
                iIOPLoopback.initLoopback(iIOPLoopbackInputStream, iIOPLoopbackOutputStream);
                this.in_stream = iIOPLoopbackInputStream;
                this.out_stream = iIOPLoopbackOutputStream;
                this.connected = true;
                ++openTransports;
                return;
            }
            this.checkSSL();
            int n = this.noOfRetries;
            while (n >= 0) {
                try {
                    this.createSocket(l);
                    if (this.timeout != 0) {
                        this.socket.setSoTimeout(this.timeout);
                    }
                    this.in_stream = this.socket.getInputStream();
                    this.out_stream = new BufferedOutputStream(this.socket.getOutputStream());
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Connected to " + this.connection_info + " from local port " + this.socket.getLocalPort() + (this.isSSL() ? " via SSL" : ""));
                    }
                    this.connected = true;
                    ++openTransports;
                    return;
                }
                catch (IOException iOException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Exception", (Throwable)iOException);
                    }
                    if (--n < 0) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Retrying to connect to " + this.connection_info);
                    }
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (TIMEOUT tIMEOUT) {
                    this.profile = null;
                    this.use_ssl = false;
                    this.ssl_port = -1;
                    throw tIMEOUT;
                }
            }
            if (n < 0) {
                this.profile = null;
                this.use_ssl = false;
                this.ssl_port = -1;
                throw new TRANSIENT("Retries exceeded, couldn't reconnect to " + this.connection_info);
            }
        }
    }

    private IIOPLoopback getLocalLoopback() {
        IIOPProfile iIOPProfile = (IIOPProfile)this.profile;
        ArrayList<ProtocolAddressBase> arrayList = new ArrayList<ProtocolAddressBase>();
        arrayList.add(iIOPProfile.getAddress());
        arrayList.addAll(iIOPProfile.getAlternateAddresses());
        Iterator iterator = arrayList.iterator();
        IIOPLoopbackRegistry iIOPLoopbackRegistry = IIOPLoopbackRegistry.getRegistry();
        while (iterator.hasNext()) {
            IIOPAddress iIOPAddress = (IIOPAddress)iterator.next();
            IIOPLoopback iIOPLoopback = iIOPLoopbackRegistry.getLoopback(iIOPAddress);
            if (iIOPLoopback == null) continue;
            return iIOPLoopback;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSocket(long l) throws IOException {
        ArrayList<ProtocolAddressBase> arrayList = new ArrayList<ProtocolAddressBase>();
        arrayList.add(((IIOPProfile)this.profile).getAddress());
        arrayList.addAll(((IIOPProfile)this.profile).getAlternateAddresses());
        Iterator iterator = arrayList.iterator();
        this.exception = null;
        this.socket = null;
        while (this.socket == null && iterator.hasNext()) {
            try {
                IIOPAddress iIOPAddress = (IIOPAddress)iterator.next();
                final SocketFactory socketFactory = this.use_ssl ? this.transportManager.getSSLSocketFactory() : this.transportManager.getSocketFactory();
                final String string = iIOPAddress.getIP();
                final int n = this.use_ssl ? this.ssl_port : iIOPAddress.getPort();
                this.connection_info = string + ":" + n;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Trying to connect to " + this.connection_info + " with timeout=" + l);
                }
                this.exception = null;
                this.socket = null;
                if (l > 0L) {
                    final ClientIIOPConnection clientIIOPConnection = this;
                    Thread thread = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            ClientIIOPConnection clientIIOPConnection4;
                            try {
                                try {
                                    ClientIIOPConnection.this.socket = socketFactory.createSocket(string, n);
                                }
                                catch (Exception exception) {
                                    ClientIIOPConnection.this.exception = exception;
                                    Object var3_2 = null;
                                    ClientIIOPConnection clientIIOPConnection3 = clientIIOPConnection;
                                    synchronized (clientIIOPConnection3) {
                                        clientIIOPConnection.notify();
                                        return;
                                    }
                                }
                                Object var3_1 = null;
                                clientIIOPConnection4 = clientIIOPConnection;
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                ClientIIOPConnection clientIIOPConnection2 = clientIIOPConnection;
                                synchronized (clientIIOPConnection2) {
                                    clientIIOPConnection.notify();
                                    throw throwable;
                                }
                            }
                            synchronized (clientIIOPConnection4) {
                                clientIIOPConnection.notify();
                                return;
                            }
                        }
                    });
                    thread.setDaemon(true);
                    try {
                        ClientIIOPConnection clientIIOPConnection2 = clientIIOPConnection;
                        synchronized (clientIIOPConnection2) {
                            thread.start();
                            clientIIOPConnection.wait(l);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.socket != null) continue;
                    if (this.exception == null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("connect to " + this.connection_info + " with timeout=" + l + " timed out");
                        }
                        thread.interrupt();
                        this.exception = new TIMEOUT("connection timeout of " + l + " milliseconds expired");
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("connect to " + this.connection_info + " with timeout=" + l + " raised exception: " + this.exception.toString());
                    continue;
                }
                this.socket = socketFactory.createSocket(string, n);
            }
            catch (Exception exception) {
                this.exception = exception;
            }
        }
        if (this.exception != null) {
            if (this.exception instanceof IOException) {
                throw (IOException)this.exception;
            }
            if (this.exception instanceof TIMEOUT) {
                throw (TIMEOUT)this.exception;
            }
            throw new IOException("Unexpected exception occured: " + this.exception.toString());
        }
    }

    public synchronized void close() {
        try {
            if (this.connected) {
                if (this.socket != null) {
                    this.socket.close();
                }
                if (this.in_stream != null) {
                    this.in_stream.close();
                }
                if (this.out_stream != null) {
                    this.out_stream.close();
                }
                --openTransports;
            }
            this.connected = false;
        }
        catch (IOException iOException) {
            throw this.to_COMM_FAILURE(iOException);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Client-side TCP transport to " + this.connection_info + " closed.");
        }
    }

    private void checkSSL() {
        Object object;
        CompoundSecMechList compoundSecMechList = (CompoundSecMechList)((IIOPProfile)this.profile).getComponent(33, class$org$omg$CSIIOP$CompoundSecMechListHelper == null ? (class$org$omg$CSIIOP$CompoundSecMechListHelper = ClientIIOPConnection.class$("org.omg.CSIIOP.CompoundSecMechListHelper")) : class$org$omg$CSIIOP$CompoundSecMechListHelper);
        TLS_SEC_TRANS tLS_SEC_TRANS = null;
        if (compoundSecMechList != null && compoundSecMechList.mechanism_list[0].transport_mech.tag == 36) {
            try {
                object = compoundSecMechList.mechanism_list[0].transport_mech.component_data;
                CDRInputStream cDRInputStream = new CDRInputStream(null, (byte[])object);
                cDRInputStream.openEncapsulatedArray();
                tLS_SEC_TRANS = TLS_SEC_TRANSHelper.read(cDRInputStream);
            }
            catch (Exception exception) {
                this.logger.warn("Error parsing TLS_SEC_TRANS: " + exception);
            }
        }
        object = (SSL)((IIOPProfile)this.profile).getComponent(20, class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = ClientIIOPConnection.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        int n = 126;
        int n2 = 0;
        int n3 = 0;
        if (this.doSupportSSL) {
            n2 = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.required_options", 16);
            n3 = this.configuration.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 16);
        }
        if (tLS_SEC_TRANS != null && (tLS_SEC_TRANS.target_supports & n) != 0 && this.doSupportSSL && (n3 & n) != 0 && ((tLS_SEC_TRANS.target_requires & n) != 0 || (n2 & n) != 0)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting TLS for connection");
            }
            this.use_ssl = true;
            this.ssl_port = tLS_SEC_TRANS.addresses[0].port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
        } else if (object != null && (((SSL)object).target_supports & n) != 0 && this.doSupportSSL && (n3 & n) != 0 && ((((SSL)object).target_requires & n) != 0 || (n2 & n) != 0)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Selecting SSL for connection");
            }
            this.use_ssl = true;
            this.ssl_port = ((SSL)object).port;
            if (this.ssl_port < 0) {
                this.ssl_port += 65536;
            }
        } else {
            if (this.doSupportSSL && (n2 & n) != 0) {
                throw new NO_PERMISSION("Client-side policy requires SSL/TLS, but server doesn't support it");
            }
            this.use_ssl = false;
            this.ssl_port = -1;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

