/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks;

import java.io.File;
import org.apache.tools.ant.Task;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractIDETask
extends Task {
    public void execute() {
        this.generateEclipseProject();
    }

    protected void generateEclipseProject() {
        if (this.isUpToDate(".project")) {
            return;
        }
        Document document = XMLUtil.createDocument();
        Element projectDescription = document.createElement("projectDescription");
        document.appendChild(projectDescription);
        Element projectName = document.createElement("name");
        projectDescription.appendChild(projectName);
        Text projectNameText = document.createTextNode(this.getProjectName());
        projectName.appendChild(projectNameText);
        Element comment = document.createElement("comment");
        projectDescription.appendChild(comment);
        Text commentText = document.createTextNode(this.getProjectDescription());
        comment.appendChild(commentText);
        Element projects = document.createElement("projects");
        projectDescription.appendChild(projects);
        this.appendEclipseProjects(projects);
        Element buildSpec = document.createElement("buildSpec");
        projectDescription.appendChild(buildSpec);
        this.appendEclipseBuildSpec(buildSpec);
        Element natures = document.createElement("natures");
        projectDescription.appendChild(natures);
        this.appendEclipseNatures(natures);
        File file = FileUtil.resolve(this.getBaseDir(), ".project");
        XMLUtil.writeXMLDocument(file, document);
        this.log("Updated " + file);
    }

    protected abstract String getProjectName();

    protected abstract String getProjectDescription();

    protected abstract boolean isUpToDate(String var1);

    protected abstract File getBaseDir();

    protected void appendEclipseProjects(Element projects) {
    }

    protected void appendEclipseBuildSpec(Element buildSpec) {
    }

    protected void appendEclipseNatures(Element natures) {
    }
}

