/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.blocks.MethodCall;

public class OptimisticReplicationInterceptor
extends OptimisticInterceptor {
    private Map broadcastTxs = new ConcurrentHashMap();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        Transaction tx = null;
        Object retval = null;
        Method meth = m.getMethod();
        if (this.txManager != null && (tx = this.txManager.getTransaction()) != null) {
            GlobalTransaction gtx = this.cache.getCurrentTransaction(tx);
            if (gtx == null) {
                throw new CacheException("failed to get global transaction");
            }
            this.log.debug((Object)(" received method " + m));
            if (meth.equals(TreeCache.optimisticPrepareMethod)) {
                if (gtx.isRemote()) {
                    this.runRemotePrepare(m);
                    retval = super.invoke(m);
                } else {
                    super.invoke(m);
                    retval = this.broadcastPrepare(m);
                }
                if (retval instanceof Throwable) {
                    throw (Throwable)retval;
                }
            } else if (meth.equals(TreeCache.commitMethod)) {
                Throwable temp = null;
                if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                    try {
                        this.broadcastCommit(m);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)" a problem occurred with remote commit", t);
                        temp = t;
                    }
                }
                retval = super.invoke(m);
                if (temp != null) {
                    throw temp;
                }
            } else if (meth.equals(TreeCache.rollbackMethod)) {
                Throwable temp = null;
                if (!gtx.isRemote() && this.broadcastTxs.containsKey(gtx)) {
                    try {
                        this.broadcastRollback(m);
                    }
                    catch (Throwable t) {
                        this.log.error((Object)" a problem occurred with remote rollback", t);
                        temp = t;
                    }
                }
                retval = super.invoke(m);
                if (temp != null) {
                    throw temp;
                }
            } else {
                this.log.debug((Object)(" received method " + m + " not handling"));
                retval = super.invoke(m);
            }
        } else {
            throw new CacheException("transaction does not exist");
        }
        return retval;
    }

    private void checkResponses(List rsps) throws Exception {
        if (rsps != null) {
            Iterator it = rsps.iterator();
            while (it.hasNext()) {
                Object rsp = it.next();
                if (rsp == null) continue;
                if (rsp instanceof RuntimeException) {
                    throw (RuntimeException)rsp;
                }
                if (!(rsp instanceof Exception)) continue;
                throw (Exception)rsp;
            }
        }
    }

    private Object runRemotePrepare(MethodCall methodCall) throws Throwable {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" remote prepare call received " + methodCall));
        }
        Object retval = null;
        Object[] args = methodCall.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        if (!gtx.isRemote()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)" received my own message (discarding it)");
            }
            return null;
        }
        List modifications = (List)args[1];
        if (modifications != null) {
            Iterator it = modifications.iterator();
            while (it.hasNext()) {
                MethodCall method_call = (MethodCall)it.next();
                try {
                    retval = super.invoke(method_call);
                }
                catch (Throwable t) {
                    this.log.error((Object)"method invocation failed", t);
                    retval = t;
                }
                if (retval == null || !(retval instanceof Throwable)) continue;
                throw new NestedRuntimeException((Throwable)retval);
            }
        }
        return retval;
    }

    protected Object broadcastPrepare(MethodCall methodCall) throws Exception {
        int num_mods;
        boolean remoteCallSync = this.cache.getCacheModeInternal() == 3;
        Object[] args = methodCall.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        List modifications = (List)args[1];
        int n = num_mods = modifications != null ? modifications.size() : 0;
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            this.broadcastTxs.put(gtx, gtx);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): broadcasting prepare for " + gtx + " (" + num_mods + " modifications"));
            }
            this.replicateCall(methodCall, remoteCallSync);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("(" + this.cache.getLocalAddress() + "):not broadcasting prepare as members are " + this.cache.getMembers()));
        }
        return null;
    }

    protected void broadcastCommit(MethodCall methodCall) throws Exception {
        boolean remoteCallSync = this.cache.getSyncCommitPhase();
        Object[] args = methodCall.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall commit_method = new MethodCall(TreeCache.commitMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote commit for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(commit_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.fatal((Object)"commit failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void broadcastRollback(MethodCall methodCall) throws Exception {
        boolean remoteCallSync = this.cache.getSyncRollbackPhase();
        Object[] args = methodCall.getArgs();
        GlobalTransaction gtx = (GlobalTransaction)args[0];
        if (this.cache.getMembers() != null && this.cache.getMembers().size() > 1) {
            try {
                this.broadcastTxs.remove(gtx);
                MethodCall rollback_method = new MethodCall(TreeCache.rollbackMethod, new Object[]{gtx});
                this.log.debug((Object)("running remote rollback for " + gtx + " and coord=" + this.cache.getLocalAddress()));
                this.replicateCall(rollback_method, remoteCallSync);
            }
            catch (Exception e) {
                this.log.error((Object)"rollback failed", (Throwable)e);
                throw e;
            }
        }
    }

    protected void replicateCall(MethodCall call, boolean sync) throws Exception {
        if (!sync && this.cache.getUseReplQueue() && this.cache.getReplQueue() != null) {
            this.cache.getReplQueue().add(new MethodCall(TreeCache.replicateMethod, new Object[]{call}));
        } else {
            List rsps = this.cache.callRemoteMethods(this.cache.getMembers(), TreeCache.replicateMethod, new Object[]{call}, sync, true, this.cache.getSyncReplTimeout());
            if (sync) {
                this.checkResponses(rsps);
            }
        }
    }
}

