/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.aop.AOPInstance;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.util.ObjectUtil;

public class InternalDelegate {
    static Log log = LogFactory.getLog((String)(class$org$jboss$cache$aop$InternalDelegate == null ? (class$org$jboss$cache$aop$InternalDelegate = InternalDelegate.class$("org.jboss.cache.aop.InternalDelegate")) : class$org$jboss$cache$aop$InternalDelegate).getName());
    public static final String CLASS_INTERNAL = "__jboss:internal:class__";
    public static final String SERIALIZED = "__SERIALIZED__";
    public static final Fqn JBOSS_INTERNAL = new Fqn("__JBossInternal__");
    public static final Fqn JBOSS_INTERNAL_MAP = new Fqn(JBOSS_INTERNAL, "__RefMap__");
    protected TreeCacheAop cache_;
    static /* synthetic */ Class class$org$jboss$cache$aop$InternalDelegate;

    InternalDelegate(TreeCacheAop cache) {
        this.cache_ = cache;
    }

    protected AOPInstance getAopInstance(Fqn fqn) throws CacheException {
        return (AOPInstance)this.cache_.peek(fqn, AOPInstance.KEY);
    }

    void resetRefCount(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            aopInstance = new AOPInstance();
        }
        if (aopInstance.getRefCount() != -1) {
            throw new IllegalStateException("InternalDelegate.resetRefCount(). Ref counter not -1 but " + aopInstance.getRefCount() + " at fqn: " + fqn);
        }
        aopInstance.incrementRefCount(null);
        this.cache_.put(fqn, AOPInstance.KEY, (Object)aopInstance);
    }

    int incrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(originalFqn);
        if (aopInstance == null) {
            throw new RuntimeException("InternalDelegate.incrementRefCount(): null aopInstance.");
        }
        int count = aopInstance.incrementRefCount(referencingFqn.toString());
        this.cache_.put(originalFqn, AOPInstance.KEY, (Object)aopInstance);
        return count;
    }

    int decrementRefCount(Fqn originalFqn, Fqn referencingFqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(originalFqn);
        if (aopInstance == null) {
            throw new RuntimeException("InternalDelegate.decrementRefCount(): null aopInstance.");
        }
        String fqn = referencingFqn == null ? null : referencingFqn.toString();
        int count = aopInstance.decrementRefCount(fqn);
        if (count < -1) {
            throw new RuntimeException("InternalDelegate.decrementRefCount(): null aopInstance.");
        }
        this.cache_.put(originalFqn, AOPInstance.KEY, (Object)aopInstance);
        return count;
    }

    boolean isReferenced(Fqn fqn) throws CacheException {
        return this.getAopInstance(fqn).getRefCount() > 0;
    }

    int getRefCount(Fqn fqn) throws CacheException {
        return this.getAopInstance(fqn).getRefCount();
    }

    String getRefFqn(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            return null;
        }
        String aliasFqn = aopInstance.getRefFqn();
        if (aliasFqn == null || aliasFqn.length() == 0) {
            return null;
        }
        String refFqn = this.getRefFqnFromAlias(aliasFqn);
        return refFqn;
    }

    void setRefFqn(Fqn fqn, String internalFqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            aopInstance = new AOPInstance();
        }
        aopInstance.setRefFqn(internalFqn);
        this.cache_.put(fqn, AOPInstance.KEY, (Object)aopInstance);
    }

    void removeRefFqn(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            throw new RuntimeException("InternalDelegate.getRefFqn(): null aopInstance.");
        }
        aopInstance.removeRefFqn();
        this.cache_.put(fqn, AOPInstance.KEY, (Object)aopInstance);
    }

    Object getPojo(Fqn fqn) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            return null;
        }
        return aopInstance.get();
    }

    void setPojo(Fqn fqn, Object pojo) throws CacheException {
        AOPInstance aopInstance = this.getAopInstance(fqn);
        if (aopInstance == null) {
            aopInstance = new AOPInstance();
            this.cache_.put(fqn, AOPInstance.KEY, (Object)aopInstance);
        }
        aopInstance.set(pojo);
    }

    void putAopClazz(Fqn fqn, Class clazz) throws CacheException {
        this.cache_.put(fqn, (Object)CLASS_INTERNAL, (Object)clazz);
    }

    Class peekAopClazz(Fqn fqn) throws CacheException {
        return (Class)this.cache_.get(fqn, (Object)CLASS_INTERNAL);
    }

    boolean isAopNode(Fqn fqn) throws CacheException {
        return this.cache_.peek(fqn, AOPInstance.KEY) != null;
    }

    void removeInternalAttributes(Fqn fqn) throws CacheException {
        this.cache_.remove(fqn, AOPInstance.KEY);
        this.cache_.remove(fqn, (Object)CLASS_INTERNAL);
    }

    void cleanUp(Fqn fqn, boolean evict) throws CacheException {
        if (!evict) {
            this.removeInternalAttributes(fqn);
            if (!this.cache_.get(fqn).hasChildren()) {
                this.cache_.remove(fqn);
            } else if (log.isTraceEnabled()) {
                log.trace((Object)("cleanup(): fqn: " + fqn + " is not empty. That means it has sub-pojos. Will not remove node"));
            }
        } else {
            this.cache_.plainEvict(fqn);
        }
    }

    String createIndirectFqn(String fqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(fqn);
        Fqn internalFqn = this.getInternalFqn(fqn);
        this.cache_.put(internalFqn, (Object)indirectFqn, (Object)fqn);
        return indirectFqn;
    }

    Fqn getInternalFqn(String fqn) {
        if (fqn == null || fqn.length() == 0) {
            throw new IllegalStateException("InternalDelegate.getInternalFqn(). fqn is either null or empty!");
        }
        String indirectFqn = this.getIndirectFqn(fqn);
        return new Fqn(JBOSS_INTERNAL_MAP, indirectFqn);
    }

    String getIndirectFqn(String fqn) {
        return ObjectUtil.getIndirectFqn(fqn);
    }

    void removeIndirectFqn(String oldFqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(oldFqn);
        this.cache_.remove(this.getInternalFqn(oldFqn), (Object)indirectFqn);
    }

    void setIndirectFqn(String oldFqn, String newFqn) throws CacheException {
        String indirectFqn = this.getIndirectFqn(oldFqn);
        Fqn tmpFqn = this.getInternalFqn(oldFqn);
        if (this.cache_.exists(tmpFqn, (Object)indirectFqn)) {
            this.cache_.put(tmpFqn, (Object)indirectFqn, (Object)newFqn);
        }
    }

    void updateIndirectFqn(Fqn originalFqn, Fqn newFqn) throws CacheException {
        this.cache_.put(this.getInternalFqn(originalFqn.toString()), (Object)this.getIndirectFqn(originalFqn.toString()), (Object)newFqn.toString());
    }

    String getRefFqnFromAlias(String aliasFqn) throws CacheException {
        return (String)this.cache_.get(this.getInternalFqn(aliasFqn), (Object)aliasFqn);
    }

    Fqn getNextFqnInLine(Fqn currentFqn) throws CacheException {
        AOPInstance ai = this.getAopInstance(currentFqn);
        String fqnStr = ai.getAndRemoveFirstFqnInList();
        Fqn newFqn = Fqn.fromString(fqnStr);
        return newFqn;
    }

    void relocate(Fqn thisFqn, Fqn newFqn) throws CacheException {
        Node node = this.cache_.get(thisFqn);
        Map value = node.getData();
        this.cache_.put(newFqn, value);
        Map children = node.getChildren();
        if (children == null || children.size() == 0) {
            this.cache_.remove(thisFqn);
            return;
        }
        Iterator it = children.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Fqn thisChildFqn = new Fqn(thisFqn, key);
            Fqn newChildFqn = new Fqn(newFqn, key);
            this.relocate(thisChildFqn, newChildFqn);
        }
        this.cache_.remove(thisFqn);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

