/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.wspolicy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.wspolicy.PolicyAssertion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyAlternative {
    private Collection<PolicyAssertion> assertions = new ArrayList<PolicyAssertion>();

    PolicyAlternative() {
    }

    static PolicyAlternative parse(Element elAll) {
        elAll = (Element)elAll.cloneNode(true);
        PolicyAlternative all = new PolicyAlternative();
        Iterator it = DOMUtils.getChildElements((Node)elAll);
        while (it.hasNext()) {
            Element el = (Element)it.next();
            all.addPolicyAssertion(new PolicyAssertion(el));
        }
        return all;
    }

    public void addPolicyAssertion(PolicyAssertion polAssertion) {
        this.assertions.add(polAssertion);
    }

    public Collection<PolicyAssertion> getPolicyAssertions() {
        return new ArrayList<PolicyAssertion>(this.assertions);
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse((String)xmlString);
        }
        catch (IOException ex) {
            throw new WSException(new StringBuffer().append("Cannot parse: ").append(xmlString).toString(), ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element elAll = this.toElement();
            return DOMWriter.printNode((Node)elAll, (boolean)true);
        }
        StringBuffer xmlBuffer = new StringBuffer("<wsp:All>");
        for (PolicyAssertion assertion : this.assertions) {
            xmlBuffer.append(assertion.toXMLString(false));
        }
        xmlBuffer.append("</wsp:All>");
        return xmlBuffer.toString();
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

