/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap.attachment;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.jboss.logging.Logger;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.ws.WSException;
import org.jboss.ws.soap.attachment.RawByteArrayOutputStream;

public class SwapableMemoryDataSource
implements DataSource {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.soap.attachment.SwapableMemoryDataSource"));
    private static final int BLOCK_SIZE = 32768;
    private static final int DEFAULT_MAX_MEMORY_SIZE = 65536;
    private static final String SWAP_PREFIX = "JBossWSsattachment";
    private static final String SWAP_SUFFIX = ".dat";
    private File swapFile;
    private String contentType = "application/octet-stream";
    private byte[] content;
    private int contentLength;
    private int maxMemorySize = 65536;

    public SwapableMemoryDataSource(InputStream inputStream, String contentType) throws IOException {
        this(inputStream, contentType, 65536);
    }

    public SwapableMemoryDataSource(InputStream inputStream, String contentType, int maxMemorySize) throws IOException {
        if (contentType != null) {
            this.contentType = contentType;
        }
        this.maxMemorySize = maxMemorySize;
        this.load(inputStream);
    }

    private void load(InputStream inputStream) throws IOException {
        RawByteArrayOutputStream rbaos;
        OutputStream os = rbaos = new RawByteArrayOutputStream();
        byte[] buffer = new byte[32768];
        int count = inputStream.read(buffer);
        while (count > 0) {
            ((OutputStream)os).write(buffer, 0, count);
            if (rbaos != null && rbaos.size() > this.maxMemorySize) {
                File tmpdir = null;
                try {
                    ServerConfig config = ServerConfigLocator.locate();
                    tmpdir = new File(config.getServerTempDir().getCanonicalPath() + "/jbossws");
                    tmpdir.mkdirs();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.swapFile = File.createTempFile(SWAP_PREFIX, SWAP_SUFFIX, tmpdir);
                this.swapFile.deleteOnExit();
                os = new FileOutputStream(this.swapFile);
                rbaos.writeTo(os);
                rbaos = null;
            }
            count = inputStream.read(buffer);
        }
        os.flush();
        ((OutputStream)os).close();
        if (rbaos == null) {
            log.debug((Object)("Using swap file, location = " + this.swapFile.toURL() + " size = " + this.swapFile.length()));
        } else {
            this.contentLength = rbaos.size();
            log.debug((Object)("Using memory buffer, size = " + this.contentLength));
            this.content = rbaos.getBytes();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.swapFile != null) {
            this.swapFile.delete();
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        if (this.content != null) {
            return new ByteArrayInputStream(this.content, 0, this.contentLength);
        }
        if (this.swapFile != null) {
            return new FileInputStream(this.swapFile);
        }
        throw new WSException("No content available");
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }
}

