/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.jsr181;

import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.ws.metadata.jsr181.HandlerChainMetaData;
import org.jboss.ws.metadata.jsr181.HandlerConfigMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class HandlerConfigFactory
implements ObjectModelFactory {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.jsr181.HandlerConfigFactory"));
    private URL fileURL;

    public HandlerConfigFactory(URL fileURL) {
        this.fileURL = fileURL;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        HandlerConfigMetaData handlerConfigMetaData = new HandlerConfigMetaData(this.fileURL);
        return handlerConfigMetaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(HandlerConfigMetaData handlerConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("handler-chain".equals(localName)) {
            return new HandlerChainMetaData(handlerConfig);
        }
        return null;
    }

    public void addChild(HandlerConfigMetaData handlerConfig, HandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName) {
        handlerConfig.addHandlerChain(handlerChain);
    }

    public Object newChild(HandlerChainMetaData handlerConfig, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("handler".equals(localName)) {
            return new HandlerMetaData();
        }
        return null;
    }

    public void addChild(HandlerChainMetaData handlerConfig, HandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName) {
        handlerConfig.addHandler(handler);
    }

    public Object newChild(HandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if ("init-param".equals(localName)) {
            return new InitParamMetaData();
        }
        return null;
    }

    public void addChild(HandlerMetaData handler, InitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName) {
        handler.addInitParam(param);
    }

    public void setValue(HandlerChainMetaData handlerChain, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("HandlerChainMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("handler-chain-name")) {
            handlerChain.setHandlerChainName(value);
        }
    }

    public void setValue(HandlerMetaData handler, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("HandlerMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("handler-name")) {
            handler.setHandlerName(value);
        } else if (localName.equals("handler-class")) {
            handler.setHandlerClass(value);
        } else if (localName.equals("soap-header")) {
            handler.addSoapHeader(navigator.resolveQName(value));
        } else if (localName.equals("soap-role")) {
            handler.addSoapRole(value);
        }
    }

    public void setValue(InitParamMetaData param, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("InitParamMetaData setValue: nuri=" + namespaceURI + " localName=" + localName + " value=" + value));
        }
        if (localName.equals("param-name")) {
            param.setParamName(value);
        } else if (localName.equals("param-value")) {
            param.setParamValue(value);
        }
    }
}

