/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.util.Iterator;
import javax.jws.WebService;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.ejb3.Ejb3ModuleMBean;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.lang.AnnotationHelper;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.AnnotationsMetaDataBuilder;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;

public class AnnotationsMetaDataBuilderEJB3
extends AnnotationsMetaDataBuilder {
    private final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.AnnotationsMetaDataBuilderEJB3"));
    protected Class annotatedClass;

    public UnifiedMetaData buildMetaData(DeploymentInfo di) {
        this.log.debug((Object)("START buildMetaData: [canonicalName=" + di.getCanonicalName() + "]"));
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData();
            wsMetaData.setResourceLoader(this.resourceLoader);
            wsMetaData.setClassLoader(this.classLoader);
            if (di.annotationsCl == null) {
                throw new WSException("Annotations class loader not initialized");
            }
            MBeanServer server = MBeanServerLocator.locateJBoss();
            Ejb3ModuleMBean ejb3Module = (Ejb3ModuleMBean)MBeanProxy.get(Class.forName("org.jboss.ejb3.Ejb3ModuleMBean"), (ObjectName)di.deployedObject, (MBeanServer)server);
            if (ejb3Module == null) {
                throw new WSException("Cannot obtain EJB3 module: " + di.deployedObject);
            }
            Iterator i$ = ejb3Module.getContainers().values().iterator();
            while (i$.hasNext()) {
                Object manager = i$.next();
                if (!(manager instanceof StatelessContainer)) continue;
                StatelessContainer container = (StatelessContainer)manager;
                String ejbClassName = container.getBeanClassName();
                Class<?> beanClass = di.annotationsCl.loadClass(ejbClassName);
                Class<?> clazz = Class.forName("javax.jws.WebService");
                Class<?> clazz2 = beanClass;
                boolean bl = false;
                bl = AnnotationHelper.isAnnotationPresent(clazz2, clazz);
                if (!bl) continue;
                Class<?> annotatedClass = beanClass;
                clazz = Class.forName("javax.jws.WebService");
                clazz2 = beanClass;
                Object object = null;
                object = AnnotationHelper.getAnnotation(clazz2, clazz);
                WebService anWebService = (WebService)object;
                String seiName = annotatedClass.getName();
                if (anWebService.endpointInterface().length() > 0) {
                    seiName = anWebService.endpointInterface();
                    annotatedClass = di.annotationsCl.loadClass(seiName);
                    clazz = Class.forName("javax.jws.WebService");
                    clazz2 = annotatedClass;
                    object = null;
                    object = AnnotationHelper.getAnnotation(clazz2, clazz);
                    anWebService = (WebService)object;
                    if (anWebService == null) {
                        throw new WSException("Interface does not have a @WebService annotation: " + seiName);
                    }
                }
                String ejbLink = container.getEjbName();
                ServerEndpointMetaData sepMetaData = this.setupEndpointFromAnnotations(wsMetaData, di, annotatedClass, ejbLink);
                sepMetaData.setEndpointImplementationName(beanClass.getName());
                sepMetaData.setServiceEndpointInterfaceName(seiName);
            }
            this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

