/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.InitParam;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPMessageHandler;
import javax.jws.soap.SOAPMessageHandlers;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.lang.AnnotationHelper;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.webservice.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.webservice.metadata.serviceref.HandlerMetaData;
import org.jboss.webservice.metadata.serviceref.InitParamMetaData;
import org.jboss.ws.WSException;
import org.jboss.ws.addressing.AddressingPropertiesImpl;
import org.jboss.ws.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.annotation.PortComponent;
import org.jboss.ws.jaxrpc.ParameterStyle;
import org.jboss.ws.jaxrpc.ParameterWrapping;
import org.jboss.ws.jaxrpc.Style;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.TypeMappingRegistryImpl;
import org.jboss.ws.jaxrpc.Use;
import org.jboss.ws.metadata.AbstractMetaDataBuilder;
import org.jboss.ws.metadata.EndpointMetaData;
import org.jboss.ws.metadata.FaultMetaData;
import org.jboss.ws.metadata.OperationMetaData;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.metadata.ServerEndpointMetaData;
import org.jboss.ws.metadata.ServiceMetaData;
import org.jboss.ws.metadata.TypeMappingMetaData;
import org.jboss.ws.metadata.TypesMetaData;
import org.jboss.ws.metadata.UnifiedMetaData;
import org.jboss.ws.metadata.jsr181.HandlerChainMetaData;
import org.jboss.ws.metadata.jsr181.HandlerConfigFactory;
import org.jboss.ws.metadata.jsr181.HandlerConfigMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.tools.JavaToWSDL;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.utils.HolderUtils;
import org.jboss.ws.utils.IOUtils;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationsMetaDataBuilder
extends AbstractMetaDataBuilder {
    private final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.metadata.AnnotationsMetaDataBuilder"));

    protected ServerEndpointMetaData setupEndpointFromAnnotations(UnifiedMetaData wsMetaData, DeploymentInfo di, Class annotatedClass, String linkName) throws ClassNotFoundException {
        String portTypeName;
        String targetNS;
        Class<?> clazz = Class.forName("javax.jws.WebService");
        GenericDeclaration genericDeclaration = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)genericDeclaration, clazz);
        WebService anWebService = (WebService)object;
        if (anWebService == null) {
            throw new WSException(new StringBuffer().append("Cannot obtain @WebService annotaion from: ").append(annotatedClass.getName()).toString());
        }
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String serviceName = anWebService.serviceName();
        if (serviceName.length() == 0) {
            serviceName = new StringBuffer().append(wsdlUtils.getJustClassName(annotatedClass.getName())).append("Service").toString();
        }
        if ((targetNS = anWebService.targetNamespace()).length() == 0) {
            targetNS = wsdlUtils.getTypeNamespace(annotatedClass);
        }
        if ((portTypeName = anWebService.name()).length() == 0) {
            portTypeName = wsdlUtils.getJustClassName(annotatedClass.getName());
        }
        ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
        wsMetaData.addService(serviceMetaData);
        QName epName = new QName(targetNS, new StringBuffer().append(portTypeName).append("Port").toString());
        ServerEndpointMetaData epMetaData = new ServerEndpointMetaData(serviceMetaData, epName);
        epMetaData.setLinkName(linkName);
        epMetaData.setAnnotated(true);
        epMetaData.setServiceEndpointInterfaceName(annotatedClass.getName());
        serviceMetaData.addEndpoint(epMetaData);
        ObjectName serviceEndpointID = this.getServiceEndpointID(di, epMetaData);
        epMetaData.setEndpointID(serviceEndpointID);
        clazz = Class.forName("javax.jws.soap.SOAPBinding");
        genericDeclaration = annotatedClass;
        boolean bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Class)genericDeclaration, clazz);
        if (bl) {
            this.processSOAPBinding(annotatedClass, epMetaData);
        }
        int webMethodCount = 0;
        for (Method method : annotatedClass.getMethods()) {
            clazz = Class.forName("javax.jws.WebMethod");
            genericDeclaration = method;
            bl = false;
            bl = AnnotationHelper.isAnnotationPresent((Method)genericDeclaration, clazz);
            if (!bl) continue;
            this.processWebMethod(epMetaData, method);
            ++webMethodCount;
        }
        if (webMethodCount == 0) {
            throw new WSException("At least one @WebMethod annotation is required");
        }
        clazz = Class.forName("javax.jws.HandlerChain");
        genericDeclaration = annotatedClass;
        bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Class)genericDeclaration, clazz);
        if (bl) {
            this.processHandlerChain(annotatedClass, epMetaData);
        }
        clazz = Class.forName("javax.jws.soap.SOAPMessageHandlers");
        genericDeclaration = annotatedClass;
        bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Class)genericDeclaration, clazz);
        if (bl) {
            this.processSOAPMessageHandlers(annotatedClass, epMetaData);
        }
        this.processOrGenerateWSDL(annotatedClass, serviceMetaData, epMetaData);
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        JBossXSModel schemaModel = wsdlDefinitions.getWsdlTypes().getSchemaModel();
        serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
        this.processPortComponent(di, annotatedClass, linkName, epMetaData);
        return epMetaData;
    }

    private void processSOAPBinding(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        Class<?> clazz = Class.forName("javax.jws.soap.SOAPBinding");
        Class clazz2 = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)clazz2, clazz);
        SOAPBinding anSoapBinding = (SOAPBinding)object;
        SOAPBinding.Style attrStyle = anSoapBinding.style();
        Style style = attrStyle == SOAPBinding.Style.RPC ? Style.RPC : Style.DOCUMENT;
        epMetaData.setStyle(style);
        SOAPBinding.Use attrUse = anSoapBinding.use();
        Use use = attrUse == SOAPBinding.Use.ENCODED ? Use.ENCODED : Use.LITERAL;
        epMetaData.setEncodingStyle(use);
        SOAPBinding.ParameterStyle attrParamStyle = anSoapBinding.parameterStyle();
        ParameterStyle paramStyle = attrParamStyle == SOAPBinding.ParameterStyle.BARE ? ParameterStyle.BARE : ParameterStyle.WRAPPED;
        epMetaData.setParameterStyle(paramStyle);
    }

    private void processOrGenerateWSDL(Class annotatedClass, ServiceMetaData serviceMetaData, EndpointMetaData endpointMetaData) {
        Class<?> clazz = Class.forName("javax.jws.WebService");
        Class clazz2 = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)clazz2, clazz);
        WebService anWebService = (WebService)object;
        String wsdlLocation = anWebService.wsdlLocation();
        if (wsdlLocation.length() > 0) {
            serviceMetaData.setWsdlFile(wsdlLocation);
        } else {
            ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
            try {
                UnifiedMetaData wsMetaData = serviceMetaData.getUnifiedMetaData();
                Thread.currentThread().setContextClassLoader(wsMetaData.getClassLoader());
                String serviceName = serviceMetaData.getName().getLocalPart();
                JavaToWSDL javaToWSDL = new JavaToWSDL("http://schemas.xmlsoap.org/wsdl/");
                javaToWSDL.setUnifiedMetaData(wsMetaData);
                javaToWSDL.setQualifiedElements(true);
                WSDLDefinitions wsdlDefinitions = javaToWSDL.generate(annotatedClass);
                JavaWsdlMapping mapping = javaToWSDL.getJavaWsdlMapping();
                String fakeMappingName = new StringBuffer().append(serviceName).append("-annotation-generated").toString();
                serviceMetaData.setJaxrpcMappingFile(fakeMappingName);
                serviceMetaData.getUnifiedMetaData().addMappingDefinition(fakeMappingName, mapping);
                ServerConfig config = ServerConfigLocator.locate();
                File tmpdir = new File(new StringBuffer().append(config.getServerTempDir().getCanonicalPath()).append("/jbossws").toString());
                tmpdir.mkdirs();
                File wsdlTmpFile = File.createTempFile(serviceName, ".wsdl", tmpdir);
                wsdlTmpFile.deleteOnExit();
                Writer writer = IOUtils.getCharsetFileWriter(wsdlTmpFile, "UTF-8");
                wsdlDefinitions.write(writer, "UTF-8");
                writer.close();
                serviceMetaData.setWsdlFile(wsdlTmpFile.toURL().toExternalForm());
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (IOException e) {
                throw new WSException("Cannot write generated wsdl", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(ctxLoader);
            }
        }
    }

    private void processPortComponent(DeploymentInfo di, Class annotatedClass, String linkName, ServerEndpointMetaData epMetaData) {
        String contextRoot = null;
        if (di.metaData instanceof WebMetaData) {
            WebMetaData webMetaData = (WebMetaData)di.metaData;
            contextRoot = webMetaData.getContextRoot();
        }
        Class<?> clazz = Class.forName("org.jboss.ws.annotation.PortComponent");
        Class clazz2 = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)clazz2, clazz);
        PortComponent anPortComponent = (PortComponent)object;
        if (anPortComponent != null) {
            if (anPortComponent.contextRoot().length() > 0) {
                contextRoot = anPortComponent.contextRoot();
            } else {
                String shortName = di.shortName;
                contextRoot = new StringBuffer().append("/").append(shortName.substring(0, shortName.indexOf(46))).toString();
            }
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = anPortComponent.urlPattern().length() > 0 ? anPortComponent.urlPattern() : new StringBuffer().append("/").append(linkName).toString();
            epMetaData.setURLPattern(urlPattern);
            String servicePath = new StringBuffer().append(contextRoot).append(urlPattern).toString();
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
        } else {
            if (contextRoot == null) {
                String shortName = di.shortName;
                contextRoot = new StringBuffer().append("/").append(shortName.substring(0, shortName.indexOf(46))).toString();
            }
            epMetaData.setContextRoot(contextRoot);
            String urlPattern = new StringBuffer().append("/").append(linkName).toString();
            epMetaData.setURLPattern(urlPattern);
            String servicePath = new StringBuffer().append(contextRoot).append(urlPattern).toString();
            epMetaData.setEndpointAddress(this.getServiceEndpointAddress(null, servicePath));
        }
        this.replaceAddressLocation(epMetaData);
    }

    private WebParam getWebParamAnnotation(Method method, int pos) {
        Method method2 = method;
        Object[][] objectArray = null;
        objectArray = AnnotationHelper.getParameterAnnotations((Method)method2);
        for (Object annotation : objectArray[pos]) {
            if (!(annotation instanceof WebParam)) continue;
            return (WebParam)annotation;
        }
        return null;
    }

    private void processWebMethod(ServerEndpointMetaData epMetaData, Method method) {
        ServiceMetaData serviceMetaData = epMetaData.getServiceMetaData();
        TypesMetaData typesMetaData = serviceMetaData.getTypesMetaData();
        String targetNS = epMetaData.getName().getNamespaceURI();
        Class<?> clazz = Class.forName("javax.jws.WebMethod");
        Method method2 = method;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Method)method2, clazz);
        WebMethod anWebMethod = (WebMethod)object;
        String operationName = anWebMethod.operationName();
        if (operationName.length() == 0) {
            operationName = method.getName();
        }
        String javaName = method.getName();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, operationName), javaName);
        clazz = Class.forName("javax.jws.Oneway");
        method2 = method;
        boolean bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Method)method2, clazz);
        opMetaData.setOneWayOperation(bl);
        opMetaData.setSOAPAction(anWebMethod.action());
        epMetaData.addOperation(opMetaData);
        HashMap<String, Integer> typeIndexes = new HashMap<String, Integer>();
        ArrayList<QName> wrappedElementNames = null;
        ArrayList<String> wrappedVariables = null;
        ArrayList<String> wrappedTypes = null;
        ParameterMetaData wrappedParameter = null;
        String encStyle = opMetaData.getUse().toURI();
        TypeMappingRegistryImpl tmRegistry = new TypeMappingRegistryImpl();
        TypeMappingImpl typeMapping = (TypeMappingImpl)tmRegistry.getTypeMapping(encStyle);
        QName xmlName = null;
        QName xmlType = null;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (opMetaData.isDocumentWrapped()) {
            xmlName = opMetaData.getXmlName();
            xmlType = opMetaData.getXmlName();
            String packageName = method.getDeclaringClass().getPackage().getName();
            String epName = epMetaData.getName().getLocalPart();
            if (epName.endsWith("Port")) {
                epName = epName.substring(0, epName.lastIndexOf("Port"));
            }
            wrappedParameter = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
            wrappedElementNames = new ArrayList<QName>(parameterTypes.length);
            wrappedVariables = new ArrayList<String>(parameterTypes.length);
            wrappedTypes = new ArrayList<String>(parameterTypes.length);
            wrappedParameter.setWrappedElementNames(wrappedElementNames);
            wrappedParameter.setWrappedVariables(wrappedVariables);
            wrappedParameter.setWrappedTypes(wrappedTypes);
            opMetaData.addParameter(wrappedParameter);
            if (!opMetaData.isOneWayOperation()) {
                xmlName = new QName(targetNS, new StringBuffer().append(operationName).append("Response").toString());
                xmlType = new QName(targetNS, new StringBuffer().append(operationName).append("Response").toString());
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, null);
                retMetaData.setWrappedVariables(new ArrayList<String>(1));
                retMetaData.setWrappedElementNames(new ArrayList<QName>(1));
                retMetaData.setWrappedTypes(new ArrayList<String>(1));
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            boolean isWrapped;
            Class javaType = parameterTypes[i];
            String javaTypeName = javaType.getName();
            WebParam anWebParam = this.getWebParamAnnotation(method, i);
            boolean bl2 = isWrapped = opMetaData.isDocumentWrapped() && (anWebParam == null || !anWebParam.header());
            if (Class.forName("javax.xml.rpc.holders.Holder").isAssignableFrom(javaType)) {
                javaType = HolderUtils.getValueType(javaType);
                javaTypeName = javaType.getName();
            }
            if ((xmlType = typeMapping.getXMLType(javaType)) == null) {
                xmlType = this.getWebParamType(opMetaData, javaType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, javaTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (isWrapped) {
                QName wrappedElementName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
                wrappedElementNames.add(wrappedElementName);
                String variable = wrappedElementName.getLocalPart();
                if (variable.length() == 0) {
                    throw new WSException("A web parameter had a name with 0 length");
                }
                variable = this.convertToProperty(variable);
                wrappedVariables.add(variable);
                wrappedTypes.add(javaTypeName);
                continue;
            }
            xmlName = this.getWebParamName(opMetaData, typeIndexes, javaType, anWebParam);
            xmlType = typeMapping.getXMLType(javaType);
            if (xmlType == null) {
                xmlType = this.getWebParamType(opMetaData, javaType);
            }
            ParameterMetaData paramMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, javaTypeName);
            if (anWebParam != null) {
                if (anWebParam.mode() == WebParam.Mode.INOUT) {
                    paramMetaData.setMode(ParameterMode.INOUT);
                }
                if (anWebParam.mode() == WebParam.Mode.OUT) {
                    paramMetaData.setMode(ParameterMode.OUT);
                }
                if (anWebParam.header()) {
                    paramMetaData.setInHeader(true);
                }
            }
            opMetaData.addParameter(paramMetaData);
        }
        Class<?> returnType = method.getReturnType();
        String returnTypeName = returnType.getName();
        if (!(returnType == Void.TYPE)) {
            if (opMetaData.isOneWayOperation()) {
                throw new IllegalArgumentException(new StringBuffer().append("[JSR-181 2.5.1] The method '").append(method.getName()).append("' can not have a return value if it is marked OneWay").toString());
            }
            xmlType = typeMapping.getXMLType(returnType);
            if (xmlType == null) {
                xmlType = this.getWebResultType(targetNS, returnType);
            }
            TypeMappingMetaData tmMetaData = new TypeMappingMetaData(typesMetaData, xmlType, returnTypeName);
            typesMetaData.addTypeMapping(tmMetaData);
            if (opMetaData.isDocumentWrapped()) {
                clazz = Class.forName("javax.jws.WebResult");
                method2 = method;
                Object object2 = null;
                object2 = AnnotationHelper.getAnnotation((Method)method2, clazz);
                QName elementName = this.getWebResultName(opMetaData, returnType, (WebResult)object2);
                ParameterMetaData retMetaData = opMetaData.getReturnParameter();
                retMetaData.getWrappedElementNames().add(elementName);
                retMetaData.getWrappedVariables().add(this.convertToProperty(elementName.getLocalPart()));
                retMetaData.getWrappedTypes().add(returnTypeName);
            } else {
                clazz = Class.forName("javax.jws.WebResult");
                method2 = method;
                Object object3 = null;
                object3 = AnnotationHelper.getAnnotation((Method)method2, clazz);
                xmlName = this.getWebResultName(opMetaData, returnType, (WebResult)object3);
                ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, returnTypeName);
                opMetaData.setReturnParameter(retMetaData);
            }
        }
        if (opMetaData.isDocumentWrapped()) {
            ParameterWrapping.generateWrapper(wrappedParameter, false);
            if (!opMetaData.isOneWayOperation()) {
                ParameterWrapping.generateWrapper(opMetaData.getReturnParameter(), false);
            }
        }
        for (Class<?> exception : method.getExceptionTypes()) {
            if (Class.forName("java.rmi.RemoteException").isAssignableFrom(exception)) continue;
            this.addFault(opMetaData, typesMetaData, exception);
        }
        this.processOpMetaExtensions(epMetaData, opMetaData);
    }

    private String convertToProperty(String variable) {
        if (Character.isUpperCase(variable.charAt(0))) {
            char c = Character.toLowerCase(variable.charAt(0));
            StringBuffer builder = new StringBuffer(variable);
            builder.setCharAt(0, c);
            variable = builder.toString();
        }
        return variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHandlerChain(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        Class<?> clazz = Class.forName("javax.jws.soap.SOAPMessageHandlers");
        Class clazz2 = annotatedClass;
        boolean bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Class)clazz2, clazz);
        if (bl) {
            throw new WSException("Cannot combine @HandlerChain with @SOAPMessageHandlers");
        }
        clazz = Class.forName("javax.jws.HandlerChain");
        clazz2 = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)clazz2, clazz);
        HandlerChain anHandlerChain = (HandlerChain)object;
        String handlerChainFile = anHandlerChain.file();
        try {
            HandlerConfigMetaData handlerConfigMetaData = null;
            URL fileURL = new URL(handlerChainFile);
            InputStream is = fileURL.openStream();
            try {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                HandlerConfigFactory factory = new HandlerConfigFactory(fileURL);
                handlerConfigMetaData = (HandlerConfigMetaData)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null);
            }
            finally {
                is.close();
            }
            for (HandlerChainMetaData handlerChainMetaData : handlerConfigMetaData.getHandlerChains()) {
                String hcName = handlerChainMetaData.getHandlerChainName();
                if (!hcName.equals(anHandlerChain.name()) && anHandlerChain.name() != null) continue;
                for (HandlerMetaData handlerMetaData : handlerChainMetaData.getHandlers()) {
                    epMetaData.addHandler(handlerMetaData);
                }
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(new StringBuffer().append("Cannot process handler chain: ").append(handlerChainFile).toString(), ex);
        }
    }

    private void processSOAPMessageHandlers(Class annotatedClass, ServerEndpointMetaData epMetaData) {
        Class<?> clazz = Class.forName("javax.jws.HandlerChain");
        Class clazz2 = annotatedClass;
        boolean bl = false;
        bl = AnnotationHelper.isAnnotationPresent((Class)clazz2, clazz);
        if (bl) {
            throw new WSException("Cannot combine @SOAPMessageHandlers with @HandlerChain");
        }
        clazz = Class.forName("javax.jws.soap.SOAPMessageHandlers");
        clazz2 = annotatedClass;
        Object object = null;
        object = AnnotationHelper.getAnnotation((Class)clazz2, clazz);
        SOAPMessageHandlers anSOAPMessageHandlers = (SOAPMessageHandlers)object;
        for (SOAPMessageHandler handler : anSOAPMessageHandlers.value()) {
            HandlerMetaData handlerMetaData = new HandlerMetaData();
            handlerMetaData.setHandlerName(handler.name());
            handlerMetaData.setHandlerClass(handler.className());
            for (InitParam initParam : handler.initParams()) {
                InitParamMetaData initParamMetaData = new InitParamMetaData();
                initParamMetaData.setParamName(initParam.name());
                initParamMetaData.setParamValue(initParam.value());
                handlerMetaData.addInitParam(initParamMetaData);
            }
            for (String role : handler.roles()) {
                handlerMetaData.addSoapRole(role);
            }
            for (String header : handler.headers()) {
                handlerMetaData.addSoapHeader(QName.valueOf(header));
            }
            epMetaData.addHandler(handlerMetaData);
        }
    }

    private QName getWebParamName(OperationMetaData opMetaData, Map<String, Integer> typeIndexes, Class javaType, WebParam webParam) {
        String shortName;
        WSDLUtils wsdlUtils;
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (webParam != null) {
            if (webParam.targetNamespace().length() > 0) {
                namespaceURI = webParam.targetNamespace();
            }
            if (webParam.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC || webParam.header() ? new QName(namespaceURI, webParam.name()) : new QName(webParam.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            wsdlUtils = WSDLUtils.getInstance();
            shortName = wsdlUtils.getJustClassName(javaType);
            xmlName = new QName(namespaceURI, shortName);
        }
        if (xmlName == null) {
            wsdlUtils = WSDLUtils.getInstance();
            shortName = wsdlUtils.getJustClassName(javaType);
            Integer index = typeIndexes.get(shortName);
            index = index != null ? new Integer(index + 1) : new Integer(1);
            typeIndexes.put(shortName, index);
            xmlName = opMetaData.isDocumentWrapped() ? new QName(namespaceURI, new StringBuffer().append(shortName).append("_").append(index).toString()) : new QName(new StringBuffer().append(shortName).append("_").append(index).toString());
        }
        return xmlName;
    }

    private QName getWebParamType(OperationMetaData opMetaData, Class javaType) {
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        return ToolsUtils.getXMLType(javaType, namespaceURI);
    }

    private QName getWebResultName(OperationMetaData opMetaData, Class javaType, WebResult anWebResult) {
        QName xmlName = null;
        String namespaceURI = opMetaData.getXmlName().getNamespaceURI();
        if (anWebResult != null) {
            if (anWebResult.targetNamespace().length() > 0) {
                namespaceURI = anWebResult.targetNamespace();
            }
            if (anWebResult.name().length() > 0) {
                xmlName = opMetaData.getStyle() != Style.RPC ? new QName(namespaceURI, anWebResult.name()) : new QName(anWebResult.name());
            }
        }
        if (xmlName == null && opMetaData.isDocumentBare()) {
            WSDLUtils wsdlUtils = WSDLUtils.getInstance();
            String shortName = wsdlUtils.getJustClassName(javaType);
            xmlName = new QName(namespaceURI, shortName);
        }
        if (xmlName == null) {
            xmlName = new QName("result");
        }
        return xmlName;
    }

    private void addFault(OperationMetaData omd, TypesMetaData tmd, Class<?> exception) {
        if (omd.isOneWayOperation()) {
            throw new IllegalStateException("JSR-181 4.3.1 - A JSR-181 processor is REQUIRED to report an error if an operation marked @Oneway has a return value, declares any checked exceptions or has any INOUT or OUT parameters.");
        }
        String name = WSDLUtils.getInstance().getJustClassName(exception);
        QName xmlName = new QName(omd.getXmlName().getNamespaceURI(), name);
        FaultMetaData fmd = new FaultMetaData(omd, xmlName, xmlName, exception.getName());
        omd.addFault(fmd);
        TypeMappingMetaData mapping = new TypeMappingMetaData(tmd, xmlName, exception.getName());
        tmd.addTypeMapping(mapping);
    }

    private QName getWebResultType(String defaultNS, Class javaType) {
        return ToolsUtils.getXMLType(javaType, defaultNS);
    }

    private void processOpMetaExtensions(ServerEndpointMetaData epMetaData, OperationMetaData opMetaData) {
        String tns = epMetaData.getName().getNamespaceURI();
        String portTypeName = epMetaData.getName().getLocalPart();
        AddressingPropertiesImpl ADDR = new AddressingPropertiesImpl();
        AddressingOpMetaExt addrExt = new AddressingOpMetaExt(ADDR.getNamespaceURI());
        addrExt.setInboundAction(new StringBuffer().append(tns).append("/").append(portTypeName).append("/IN").toString());
        if (!opMetaData.isOneWayOperation()) {
            addrExt.setOutboundAction(new StringBuffer().append(tns).append("/").append(portTypeName).append("/OUT").toString());
        }
        opMetaData.addExtension(addrExt);
    }
}

