/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.jaxrpc;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.JAXRPCException;
import org.jboss.logging.Logger;
import org.jboss.ws.jaxrpc.ServiceImpl;

public class ServiceProxy
implements InvocationHandler {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.ws.jaxrpc.ServiceProxy"));
    private ServiceImpl jaxrpcService;
    private List objectMethods = new ArrayList();
    private List jaxrpcServiceMethods = new ArrayList();
    private List serviceInterfaceMethods = new ArrayList();
    private Method getPortMethod;

    public ServiceProxy(ServiceImpl service, Class siClass) {
        this.jaxrpcService = service;
        this.objectMethods.addAll(Arrays.asList((Object[])Class.forName("java.lang.Object").getMethods()));
        this.jaxrpcServiceMethods.addAll(Arrays.asList((Object[])Class.forName("org.jboss.ws.jaxrpc.ServiceExt").getMethods()));
        if (!siClass.getName().equals("javax.xml.rpc.Service")) {
            this.serviceInterfaceMethods.addAll(Arrays.asList((Object[])siClass.getDeclaredMethods()));
        }
        try {
            this.getPortMethod = Class.forName("javax.xml.rpc.Service").getMethod("getPort", Class.forName("java.lang.Class"));
        }
        catch (NoSuchMethodException e) {
            throw new JAXRPCException(e.toString());
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        try {
            Object retObj = null;
            if (this.jaxrpcServiceMethods.contains(method)) {
                log.debug((Object)("Invoke on jaxrpc service: " + methodName));
                if (method.getName().equals("getPort")) {
                    Remote port = (Remote)method.invoke((Object)this.jaxrpcService, args);
                    return port;
                }
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            if (this.serviceInterfaceMethods.contains(method)) {
                log.debug((Object)("Invoke on service interface: " + methodName));
                Class<?> seiClass = method.getReturnType();
                retObj = this.getPortMethod.invoke((Object)this.jaxrpcService, seiClass);
                return retObj;
            }
            if (this.objectMethods.contains(method)) {
                log.debug((Object)("Invoke on object: " + methodName));
                retObj = method.invoke((Object)this.jaxrpcService, args);
                return retObj;
            }
            throw new JAXRPCException("Don't know how to invoke: " + method);
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Exception ex) throws Throwable {
        Throwable th = ex;
        if (ex instanceof InvocationTargetException) {
            th = ((InvocationTargetException)ex).getTargetException();
        }
        log.error((Object)"Service error", th);
        throw th;
    }
}

