/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingProperties;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.SOAPMessageContextImpl;

public abstract class EventingEndpointBase {
    private static Logger log = Logger.getLogger(Class.forName("org.jboss.ws.eventing.EventingEndpointBase"));
    protected SubscriptionManagerMBean subscriptionManager = null;
    private AddressingBuilder addrBuilder = null;

    protected static AddressingProperties getAddrProperties() {
        SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
        AddressingProperties inProps = (AddressingProperties)msgContext.getProperty("javax.xml.ws.addressing.context.inbound");
        EventingEndpointBase.assertAddrProperties(inProps);
        return inProps;
    }

    protected void setReplyAction(URI replyAction) {
    }

    protected SubscriptionManagerMBean getSubscriptionManager() {
        if (null == this.subscriptionManager) {
            SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
            this.subscriptionManager = factory.createSubscriptionManager();
        }
        return this.subscriptionManager;
    }

    protected AddressingBuilder getAddrBuilder() {
        if (null == this.addrBuilder) {
            this.addrBuilder = AddressingBuilder.getAddressingBuilder();
        }
        return this.addrBuilder;
    }

    protected static void assertAddrProperties(AddressingProperties inProps) throws SOAPFaultException {
        if (null == inProps) {
            throw new SOAPFaultException(Constants.SOAP11_FAULT_CODE_CLIENT, "Addressing headers missing from request", "wse:InvalidMessage", null);
        }
    }

    public QName buildFaultQName(String elementName) {
        return new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", elementName, "wse");
    }
}

