/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.soap;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.WSException;
import org.jboss.ws.binding.BindingException;
import org.jboss.ws.jaxrpc.TypeMappingImpl;
import org.jboss.ws.jaxrpc.encoding.DeserializerFactoryBase;
import org.jboss.ws.jaxrpc.encoding.DeserializerSupport;
import org.jboss.ws.jaxrpc.encoding.NullValueSerializer;
import org.jboss.ws.jaxrpc.encoding.SerializationContextImpl;
import org.jboss.ws.jaxrpc.encoding.SerializerFactoryBase;
import org.jboss.ws.jaxrpc.encoding.SerializerSupport;
import org.jboss.ws.jaxrpc.encoding.XOPDeserializer;
import org.jboss.ws.jaxrpc.encoding.XOPSerializer;
import org.jboss.ws.metadata.ParameterMetaData;
import org.jboss.ws.soap.MessageContextAssociation;
import org.jboss.ws.soap.NameImpl;
import org.jboss.ws.soap.SOAPElementImpl;
import org.jboss.ws.soap.SOAPEnvelopeImpl;
import org.jboss.ws.soap.SOAPFactoryImpl;
import org.jboss.ws.soap.SOAPMessageContextImpl;
import org.jboss.ws.soap.SOAPMessageImpl;
import org.jboss.ws.utils.JavaUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SOAPContentElement
extends SOAPElementImpl {
    private static Logger log = Logger.getLogger(SOAPContentElement.class);
    private String xmlFragment;
    private Object objectValue;
    private boolean isDOMValid;
    private boolean isObjectValid;
    private boolean expandingToDOM;
    private ParameterMetaData paramMetaData;

    public SOAPContentElement(Name name) {
        super(name);
    }

    public SOAPContentElement(SOAPElementImpl element) {
        super(element);
        this.isDOMValid = true;
    }

    public ParameterMetaData getParamMetaData() {
        return this.paramMetaData;
    }

    public void setParamMetaData(ParameterMetaData paramMetaData) {
        this.paramMetaData = paramMetaData;
    }

    public QName getXmlType() {
        return this.paramMetaData != null ? this.paramMetaData.getXmlType() : null;
    }

    public Class getJavaType() {
        return this.paramMetaData != null ? this.paramMetaData.getJavaType() : null;
    }

    public String getXMLFragment() throws SOAPException {
        if (this.xmlFragment == null && this.isObjectValid) {
            this.assertContentMapping();
            QName xmlType = this.getXmlType();
            Class javaType = this.getJavaType();
            log.debug((Object)("getXMLFragment from Object [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            SerializationContextImpl serContext = msgContext.getSerializationContext();
            serContext.setProperty("org.jboss.ws.metadata.ParameterMetaData", this.paramMetaData);
            TypeMappingImpl typeMapping = serContext.getTypeMapping();
            QName xmlName = this.getQName();
            try {
                String nsURI;
                SerializerSupport ser;
                if (this.objectValue != null) {
                    if (this.getXMimeContentType() == null) {
                        SerializerFactoryBase serializerFactory = this.getSerializerFactory(typeMapping, javaType, xmlType);
                        ser = serializerFactory.getSerializer();
                    } else {
                        ser = new XOPSerializer();
                    }
                } else {
                    ser = new NullValueSerializer();
                    if (this.getNamespaceURI("xsi") == null) {
                        this.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                    }
                }
                NamedNodeMap attributes = this.getAttributes();
                this.xmlFragment = ser.serialize(xmlName, xmlType, this.objectValue, serContext, attributes);
                QName compXmlType = this.paramMetaData.getSOAPArrayCompType();
                if (compXmlType != null && (nsURI = this.getNamespaceURI(compXmlType.getPrefix())) == null) {
                    this.addNamespaceDeclaration(compXmlType.getPrefix(), compXmlType.getNamespaceURI());
                }
                log.debug((Object)("xmlFragment: " + this.xmlFragment));
            }
            catch (BindingException e) {
                throw new JAXRPCException((Throwable)e);
            }
        } else if (this.xmlFragment == null && this.isDOMValid) {
            log.debug((Object)"getXMLFragment from DOM");
            this.xmlFragment = DOMWriter.printNode((Node)((Object)this), (boolean)false);
            log.debug((Object)("xmlFragment: " + this.xmlFragment));
        }
        if (this.xmlFragment == null || !this.xmlFragment.startsWith("<")) {
            throw new WSException("Invalid XMLFragment: " + this.xmlFragment);
        }
        return this.xmlFragment;
    }

    public void setXMLFragment(String xmlFragment) {
        log.debug((Object)("setXMLFragment: " + xmlFragment));
        if (xmlFragment == null || !xmlFragment.startsWith("<")) {
            throw new WSException("Invalid XMLFragment: " + xmlFragment);
        }
        this.removeContentsAsIs();
        this.removeAttributesAsIs();
        this.resetElementContent();
        this.xmlFragment = xmlFragment;
        this.invalidateDOMContent();
        this.invalidateObjectContent();
    }

    public Object getObjectValue() throws SOAPException {
        if (!this.isObjectValid) {
            QName xmlType = this.getXmlType();
            Class javaType = this.getJavaType();
            log.debug((Object)("getObjectValue [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
            this.assertContentMapping();
            SOAPMessageContextImpl msgContext = MessageContextAssociation.peekMessageContext();
            if (msgContext == null) {
                throw new WSException("MessageContext not available");
            }
            SerializationContextImpl serContext = msgContext.getSerializationContext();
            serContext.setProperty("org.jboss.ws.metadata.ParameterMetaData", this.paramMetaData);
            try {
                String strContent;
                DeserializerSupport des;
                if (this.getXMimeContentType() == null) {
                    TypeMappingImpl typeMapping = serContext.getTypeMapping();
                    DeserializerFactoryBase deserializerFactory = this.getDeserializerFactory(typeMapping, javaType, xmlType);
                    des = deserializerFactory.getDeserializer();
                    strContent = this.insertNamespaceDeclarations(this.getXMLFragment());
                } else {
                    des = new XOPDeserializer();
                    SOAPElement xopInclude = this.getXOPIncludeElement();
                    if (xopInclude == null) {
                        throw new WSException("Cannot find element xop:Include");
                    }
                    strContent = DOMUtils.getAttributeValue((Element)xopInclude, (String)"href");
                    if (strContent == null) {
                        throw new WSException("Cannot find XOP href attribute");
                    }
                }
                Object obj = des.deserialize(this.getQName(), xmlType, strContent, serContext);
                if (obj != null) {
                    Class<?> objType = obj.getClass();
                    boolean isAssignable = JavaUtils.isAssignableFrom(javaType, objType);
                    if (!isAssignable && javaType.isArray()) {
                        try {
                            Method toArrayMethod = objType.getMethod("toArray", new Class[0]);
                            Class<?> returnType = toArrayMethod.getReturnType();
                            if (JavaUtils.isAssignableFrom(javaType, returnType)) {
                                Method getValueMethod = objType.getMethod("getValue", new Class[0]);
                                Object value = getValueMethod.invoke(obj, new Object[0]);
                                if (value != null) {
                                    obj = toArrayMethod.invoke(obj, new Object[0]);
                                } else {
                                    Class<?> componentType = javaType.getComponentType();
                                    obj = Array.newInstance(componentType, 0);
                                }
                                isAssignable = true;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!isAssignable) {
                        throw new WSException("Java type '" + javaType + "' is not assignable from: " + objType.getName());
                    }
                }
                this.objectValue = obj;
                this.isObjectValid = true;
            }
            catch (BindingException e) {
                throw new JAXRPCException((Throwable)e);
            }
            log.debug((Object)("objectValue: " + (this.objectValue != null ? this.objectValue.getClass().getName() : null)));
        }
        return this.objectValue;
    }

    public void setObjectValue(Object objValue) {
        log.debug((Object)("setObjectValue: " + objValue));
        this.removeContentsAsIs();
        this.resetElementContent();
        this.objectValue = objValue;
        this.isObjectValid = true;
    }

    public String getXMimeContentType() {
        String contentType = this.getAttributeNS("http://www.w3.org/2004/11/xmlmime", "contentType");
        return contentType.length() > 0 ? contentType : null;
    }

    public void setXMimeContentType(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("Invalid null xmime:contentType");
        }
        log.debug((Object)("xmime:contentType=" + contentType));
        SOAPMessageImpl soapMessage = (SOAPMessageImpl)((SOAPEnvelopeImpl)this.getSOAPEnvelope()).getSOAPMessage();
        soapMessage.setXOPMessage(true);
        this.setAttributeNS("http://www.w3.org/2004/11/xmlmime", "xmime:contentType", contentType);
        if (this.getNamespaceURI("xmime") == null) {
            this.addNamespaceDeclaration("xmime", "http://www.w3.org/2004/11/xmlmime");
        }
    }

    public SOAPElement getXOPIncludeElement() {
        QName qname = new QName("http://www.w3.org/2004/08/xop/include", "Include");
        return (SOAPElement)DOMUtils.getFirstChildElement((Node)((Object)this), (QName)qname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContentsAsIs() {
        log.trace((Object)"removeContentsAsIs");
        boolean cachedFlag = this.isDOMValid;
        try {
            this.isDOMValid = true;
            super.removeContents();
        }
        finally {
            this.isDOMValid = cachedFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAttributesAsIs() {
        log.trace((Object)"removeAttributesAsIs");
        boolean cachedFlag = this.isDOMValid;
        try {
            this.isDOMValid = true;
            Iterator it = super.getAllAttributes();
            while (it.hasNext()) {
                Name attrName = (Name)it.next();
                if ("xmlns".equals(attrName.getPrefix())) continue;
                this.removeAttribute(attrName);
            }
        }
        finally {
            this.isDOMValid = cachedFlag;
        }
    }

    private SerializerFactoryBase getSerializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType) {
        Class arrayWrapperType;
        SerializerFactoryBase serializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(javaType, xmlType);
        if (serializerFactory == null && javaType.isArray() && (arrayWrapperType = typeMapping.getJavaType(xmlType)) != null) {
            try {
                Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
                Class<?> returnType = toArrayMethod.getReturnType();
                if (JavaUtils.isAssignableFrom(javaType, returnType)) {
                    serializerFactory = (SerializerFactoryBase)typeMapping.getSerializer(arrayWrapperType, xmlType);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (serializerFactory == null) {
            throw new JAXRPCException("Cannot obtain serializer factory for: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
        }
        return serializerFactory;
    }

    private DeserializerFactoryBase getDeserializerFactory(TypeMappingImpl typeMapping, Class javaType, QName xmlType) {
        Class arrayWrapperType;
        DeserializerFactoryBase deserializerFactory = (DeserializerFactoryBase)typeMapping.getDeserializer(javaType, xmlType);
        if (deserializerFactory == null && javaType.isArray() && (arrayWrapperType = typeMapping.getJavaType(xmlType)) != null) {
            try {
                Method toArrayMethod = arrayWrapperType.getMethod("toArray", new Class[0]);
                Class<?> returnType = toArrayMethod.getReturnType();
                if (JavaUtils.isAssignableFrom(javaType, returnType)) {
                    deserializerFactory = (DeserializerFactoryBase)typeMapping.getDeserializer(arrayWrapperType, xmlType);
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (deserializerFactory == null) {
            throw new JAXRPCException("Cannot obtain deserializer factory for: [xmlType=" + xmlType + ",javaType=" + javaType + "]");
        }
        return deserializerFactory;
    }

    private void assertContentMapping() {
        if (this.getJavaType() == null) {
            throw new WSException("javaType cannot be null");
        }
        if (this.getXmlType() == null) {
            throw new WSException("xmlType cannot be null");
        }
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addChildElement(child);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addChildElement(localName, prefix);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addChildElement(localName, prefix, uri);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public SOAPElement addChildElement(Name name) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addChildElement(name);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public SOAPElement addChildElement(String name) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addChildElement(name);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        this.expandToDOM();
        SOAPElement soapElement = super.addTextNode(value);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return soapElement;
    }

    public Iterator getChildElements() {
        this.expandToDOM();
        return super.getChildElements();
    }

    public Iterator getChildElements(Name name) {
        this.expandToDOM();
        return super.getChildElements(name);
    }

    public void removeContents() {
        this.expandToDOM();
        super.removeContents();
        this.invalidateObjectContent();
        this.invalidateXMLContent();
    }

    public Iterator getAllAttributes() {
        this.expandToDOM();
        return super.getAllAttributes();
    }

    public String getAttribute(String name) {
        this.expandToDOM();
        return super.getAttribute(name);
    }

    public Attr getAttributeNode(String name) {
        this.expandToDOM();
        return super.getAttributeNode(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        this.expandToDOM();
        return super.getAttributeNodeNS(namespaceURI, localName);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        this.expandToDOM();
        return super.getAttributeNS(namespaceURI, localName);
    }

    public String getAttributeValue(Name name) {
        this.expandToDOM();
        return super.getAttributeValue(name);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        this.expandToDOM();
        return super.addAttribute(name, value);
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String nsURI) {
        this.expandToDOM();
        return super.addNamespaceDeclaration(prefix, nsURI);
    }

    public Name getElementName() {
        return super.getElementName();
    }

    public NodeList getElementsByTagName(String name) {
        this.expandToDOM();
        return super.getElementsByTagName(name);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        this.expandToDOM();
        return super.getElementsByTagNameNS(namespaceURI, localName);
    }

    public String getEncodingStyle() {
        this.expandToDOM();
        return super.getEncodingStyle();
    }

    public Iterator getNamespacePrefixes() {
        this.expandToDOM();
        return super.getNamespacePrefixes();
    }

    public String getNamespaceURI(String prefix) {
        this.expandToDOM();
        return super.getNamespaceURI(prefix);
    }

    public TypeInfo getSchemaTypeInfo() {
        this.expandToDOM();
        return super.getSchemaTypeInfo();
    }

    public String getTagName() {
        this.expandToDOM();
        return super.getTagName();
    }

    public Iterator getVisibleNamespacePrefixes() {
        this.expandToDOM();
        return super.getVisibleNamespacePrefixes();
    }

    public boolean hasAttribute(String name) {
        this.expandToDOM();
        return super.hasAttribute(name);
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) {
        this.expandToDOM();
        return super.hasAttributeNS(namespaceURI, localName);
    }

    public boolean removeAttribute(Name name) {
        this.expandToDOM();
        log.trace((Object)("removeAttribute: " + name.getQualifiedName()));
        return super.removeAttribute(name);
    }

    public void removeAttribute(String name) throws DOMException {
        this.expandToDOM();
        log.trace((Object)("removeAttribute: " + name));
        super.removeAttribute(name);
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        this.expandToDOM();
        log.trace((Object)("removeAttribute: " + oldAttr.getNodeName()));
        return super.removeAttributeNode(oldAttr);
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        this.expandToDOM();
        log.trace((Object)("removeAttributeNS: {" + namespaceURI + "}" + localName));
        super.removeAttributeNS(namespaceURI, localName);
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        this.expandToDOM();
        log.trace((Object)("removeNamespaceDeclaration: " + prefix));
        return super.removeNamespaceDeclaration(prefix);
    }

    public void setAttribute(String name, String value) throws DOMException {
        this.expandToDOM();
        log.trace((Object)("setAttribute: [name=" + name + ",value=" + value + "]"));
        super.setAttribute(name, value);
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        this.expandToDOM();
        return super.setAttributeNode(newAttr);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        this.expandToDOM();
        return super.setAttributeNodeNS(newAttr);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        this.expandToDOM();
        super.setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        this.expandToDOM();
        super.setEncodingStyle(encodingStyle);
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        this.expandToDOM();
        super.setIdAttribute(name, isId);
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        this.expandToDOM();
        super.setIdAttributeNode(idAttr, isId);
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        this.expandToDOM();
        super.setIdAttributeNS(namespaceURI, localName, isId);
    }

    public Node appendChild(Node newChild) throws DOMException {
        log.trace((Object)("appendChild: " + newChild));
        this.expandToDOM();
        Node node = super.appendChild(newChild);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return node;
    }

    public Node cloneNode(boolean deep) {
        log.trace((Object)("cloneNode: deep=" + deep));
        this.expandToDOM();
        return super.cloneNode(deep);
    }

    public NodeList getChildNodes() {
        this.expandToDOM();
        return super.getChildNodes();
    }

    public Node getFirstChild() {
        this.expandToDOM();
        return super.getFirstChild();
    }

    public Node getLastChild() {
        this.expandToDOM();
        return super.getLastChild();
    }

    public String getValue() {
        this.expandToDOM();
        return super.getValue();
    }

    public boolean hasChildNodes() {
        this.expandToDOM();
        return super.hasChildNodes();
    }

    public Node removeChild(Node oldChild) throws DOMException {
        log.trace((Object)("removeChild: " + oldChild));
        this.expandToDOM();
        Node node = super.removeChild(oldChild);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return node;
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        log.trace((Object)("replaceChild: [new=" + newChild + ",old=" + oldChild + "]"));
        this.expandToDOM();
        Node node = super.replaceChild(newChild, oldChild);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
        return node;
    }

    public void setValue(String value) {
        log.trace((Object)("setValue: " + value));
        this.expandToDOM();
        super.setValue(value);
        this.invalidateObjectContent();
        this.invalidateXMLContent();
    }

    public NamedNodeMap getAttributes() {
        this.expandToDOM();
        return super.getAttributes();
    }

    public boolean hasAttributes() {
        this.expandToDOM();
        return super.hasAttributes();
    }

    private void expandToDOM() {
        if (!this.isDOMValid && !this.expandingToDOM) {
            log.trace((Object)"BEGIN: expandToDOM");
            this.expandingToDOM = true;
            try {
                if (this.xmlFragment == null && this.isObjectValid) {
                    this.xmlFragment = this.getXMLFragment();
                }
                if (this.xmlFragment != null) {
                    Name elementName;
                    String rootNS;
                    String rootPrefix;
                    String wrappedXMLFragment = this.insertNamespaceDeclarations("<wrapper>" + this.xmlFragment + "</wrapper>");
                    Element contentRoot = DOMUtils.parse((String)wrappedXMLFragment);
                    String rootLocalName = (contentRoot = DOMUtils.getFirstChildElement((Node)contentRoot)).getLocalName();
                    NameImpl contentRootName = new NameImpl(rootLocalName, rootPrefix = contentRoot.getPrefix(), rootNS = contentRoot.getNamespaceURI());
                    if (!((Object)contentRootName).equals(elementName = this.getElementName())) {
                        throw new WSException("Content root name does not match element name: " + contentRootName + " != " + elementName);
                    }
                    DOMUtils.copyAttributes((Element)((Object)this), (Element)contentRoot);
                    SOAPFactoryImpl soapFactory = new SOAPFactoryImpl();
                    NodeList nlist = contentRoot.getChildNodes();
                    for (int i = 0; i < nlist.getLength(); ++i) {
                        String nodeValue;
                        Node child = nlist.item(i);
                        short childType = child.getNodeType();
                        if (childType == 1) {
                            SOAPElementImpl soapElement = soapFactory.createElement((Element)child, true);
                            super.addChildElement(soapElement);
                            continue;
                        }
                        if (childType == 3) {
                            nodeValue = child.getNodeValue();
                            super.addTextNode(nodeValue);
                            continue;
                        }
                        if (childType == 4) {
                            nodeValue = child.getNodeValue();
                            super.addTextNode(nodeValue);
                            continue;
                        }
                        log.trace((Object)("Ignore child type: " + childType));
                    }
                }
                this.isDOMValid = true;
            }
            catch (RuntimeException e) {
                this.invalidateDOMContent();
                throw e;
            }
            catch (Exception e) {
                this.invalidateDOMContent();
                throw new JAXRPCException((Throwable)e);
            }
            finally {
                this.expandingToDOM = false;
                log.trace((Object)"END: expandToDOM");
            }
            this.invalidateXMLContent();
        }
    }

    public String insertNamespaceDeclarations(String xmlfragment) {
        StringBuilder xmlBuffer = new StringBuilder(xmlfragment);
        int endIndex = xmlfragment.indexOf(">");
        int insIndex = endIndex;
        if (xmlfragment.charAt(insIndex - 1) == '/') {
            --insIndex;
        }
        for (SOAPContentElement soapElement = this; soapElement != null; soapElement = soapElement.getParentElement()) {
            Iterator it = soapElement.getNamespacePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String nsURI = soapElement.getNamespaceURI(prefix);
                String nsDecl = " xmlns:" + prefix + "='" + nsURI + "'";
                int nsIndex = xmlBuffer.indexOf("xmlns:" + prefix);
                if (nsIndex >= 0 && nsIndex <= endIndex) continue;
                xmlBuffer.insert(insIndex, nsDecl);
                endIndex += nsDecl.length();
            }
        }
        log.trace((Object)("insertNamespaceDeclarations: " + xmlBuffer));
        return xmlBuffer.toString();
    }

    private void invalidateDOMContent() {
        if (!this.expandingToDOM) {
            log.trace((Object)"invalidateDOMContent");
            this.isDOMValid = false;
        }
    }

    private void invalidateObjectContent() {
        if (!this.expandingToDOM) {
            log.trace((Object)"invalidateObjectContent");
            this.isObjectValid = false;
            this.objectValue = null;
        }
    }

    private void invalidateXMLContent() {
        if (!this.expandingToDOM) {
            log.trace((Object)"invalidateXMLContent");
            this.xmlFragment = null;
        }
    }

    private void resetElementContent() {
        if (!this.expandingToDOM) {
            log.trace((Object)"resetElementContent");
            this.invalidateDOMContent();
            this.invalidateObjectContent();
            this.invalidateXMLContent();
        }
    }
}

