/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.eventing;

import java.rmi.RemoteException;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AttributedURI;
import org.jboss.logging.Logger;
import org.jboss.ws.eventing.EventSourceEndpoint;
import org.jboss.ws.eventing.EventingEndpointBase;
import org.jboss.ws.eventing.element.EndpointReference;
import org.jboss.ws.eventing.element.SubscribeRequest;
import org.jboss.ws.eventing.element.SubscribeResponse;
import org.jboss.ws.eventing.element.SubscriptionEndRequest;
import org.jboss.ws.eventing.mgmt.Filter;
import org.jboss.ws.eventing.mgmt.SubscriptionError;
import org.jboss.ws.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.eventing.mgmt.SubscriptionTicket;

public class EventSourceEndpointImpl
extends EventingEndpointBase
implements EventSourceEndpoint {
    private static Logger log = Logger.getLogger(EventSourceEndpointImpl.class);

    public SubscribeResponse subscribe(SubscribeRequest request) throws RemoteException {
        try {
            AddressingProperties inProps = EventSourceEndpointImpl.getAddrProperties();
            AttributedURI eventSourceURI = inProps.getTo();
            log.debug((Object)("Subscribe request for event source: " + eventSourceURI.getURI()));
            this.assertSubscriberEndpoints(request);
            EndpointReference notifyTo = request.getDelivery().getNotifyTo();
            EndpointReference endTo = request.getEndTo();
            Filter filter = null;
            if (request.getFilter() != null) {
                filter = new Filter(request.getFilter().getDialect(), request.getFilter().get_value());
            }
            SubscriptionManagerMBean subscriptionManager = this.getSubscriptionManager();
            SubscriptionTicket ticket = subscriptionManager.subscribe(eventSourceURI.getURI(), notifyTo, endTo, request.getExpires(), filter);
            SubscribeResponse res = new SubscribeResponse();
            res.setExpires(ticket.getExpires());
            res.setSubscriptionManager(ticket.getSubscriptionManager());
            return res;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    public SubscriptionEndRequest subscriptionEnd() throws RemoteException {
        return new SubscriptionEndRequest();
    }

    private void assertSubscriberEndpoints(SubscribeRequest request) {
        if (null == request.getDelivery().getNotifyTo() || null == request.getEndTo()) {
            throw new SOAPFaultException(this.buildFaultQName("InvalidMessage"), "Subcriber endpoint information missing from request", null, null);
        }
    }
}

