/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import java.util.Vector;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueFactory;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Property;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class SourceAdapter
implements PropertySource {
    private Hashtable m_propTable;
    private Hashtable m_values;
    private Hashtable m_propValues;
    private Object m_object;
    private Property[] m_props;
    private ORB orb;

    protected SourceAdapter() {
    }

    public SourceAdapter(Object object, Property[] props) {
        this.orb = ((ObjectImpl)object)._orb();
        this.m_object = object;
        this.m_props = props;
        this.m_propTable = new Hashtable();
        this.m_values = new Hashtable();
        this.m_propValues = new Hashtable();
        for (int i = 0; i < props.length; ++i) {
            this.m_propTable.put(props[i].name, props[i]);
        }
    }

    public Object getObject() {
        return this.m_object;
    }

    public Property[] getProperties() {
        return this.m_props;
    }

    public Property[] getProperties(SpecifiedProps desired_props) {
        Property[] result = null;
        if (desired_props.discriminator() == HowManyProps.all) {
            Vector<Property> vec = new Vector<Property>();
            for (int i = 0; i < this.m_props.length; ++i) {
                Any value = this.getPropertyValue(this.m_props[i].name);
                if (value == null) continue;
                vec.addElement(new Property(this.m_props[i].name, value));
            }
            result = new Property[vec.size()];
            vec.copyInto(result);
        } else if (desired_props.discriminator() == HowManyProps.some) {
            String[] names = desired_props.prop_names();
            Vector<Property> vec = new Vector<Property>();
            for (int i = 0; i < names.length; ++i) {
                Any value = this.getPropertyValue(names[i]);
                if (value == null) continue;
                vec.addElement(new Property(names[i], value));
            }
            result = new Property[vec.size()];
            vec.copyInto(result);
        } else if (desired_props.discriminator() == HowManyProps.none) {
            result = new Property[]{};
        }
        return result;
    }

    public boolean exists(String property) {
        return this.m_propTable.containsKey(property);
    }

    public Value getValue(String property) {
        Value result = null;
        java.lang.Object v = this.m_values.get(property);
        if (v == null) {
            Property p = (Property)this.m_propTable.get(property);
            if (p == null) {
                return null;
            }
            Any val = this.getPropertyValue(property);
            if (val == null) {
                return null;
            }
            this.m_propValues.put(property, val);
            try {
                TypeCode tc = val.type();
                while (tc.kind() == TCKind.tk_alias) {
                    tc = tc.content_type();
                }
                TCKind kind = tc.kind();
                if (kind == TCKind.tk_sequence) {
                    return null;
                }
                switch (kind.value()) {
                    case 2: {
                        short s = val.extract_short();
                        result = ValueFactory.createShort(s);
                        break;
                    }
                    case 3: {
                        int l = val.extract_long();
                        result = ValueFactory.createLong(l);
                        break;
                    }
                    case 4: {
                        short i = val.extract_short();
                        result = ValueFactory.createUShort(i);
                        break;
                    }
                    case 5: {
                        long l = val.extract_ulong();
                        result = ValueFactory.createULong(l);
                        break;
                    }
                    case 6: {
                        float f = val.extract_float();
                        result = ValueFactory.createFloat(f);
                        break;
                    }
                    case 7: {
                        double d = val.extract_double();
                        result = ValueFactory.createDouble(d);
                        break;
                    }
                    case 8: {
                        boolean b = val.extract_boolean();
                        result = ValueFactory.createBoolean(b);
                        break;
                    }
                    case 9: {
                        char c = val.extract_char();
                        result = ValueFactory.createChar(c);
                        break;
                    }
                    case 18: {
                        String s = val.extract_string();
                        result = ValueFactory.createString(s);
                    }
                }
            }
            catch (BadKind e) {
                throw new RuntimeException();
            }
            catch (BAD_OPERATION e) {
                throw new RuntimeException();
            }
            this.m_values.put(property, result);
        } else if (v instanceof Value) {
            result = (Value)v;
        }
        return result;
    }

    public Value[] getSequenceValues(String property) {
        Value[] result = null;
        java.lang.Object v = this.m_values.get(property);
        if (v == null) {
            Property p = (Property)this.m_propTable.get(property);
            if (p == null) {
                return null;
            }
            Any val = this.getPropertyValue(property);
            if (val == null) {
                return null;
            }
            this.m_propValues.put(property, val);
            try {
                TypeCode tc = val.type();
                while (tc.kind() == TCKind.tk_alias) {
                    tc = tc.content_type();
                }
                if (tc.kind() != TCKind.tk_sequence) {
                    return null;
                }
                tc = tc.content_type();
                TCKind kind = tc.kind();
                DynAny da = DynAnyFactoryHelper.narrow(this.orb.resolve_initial_references("DynAnyFactory")).create_dyn_any(val);
                DynSequence ds = DynSequenceHelper.narrow(da);
                int len = ds.get_length();
                result = new Value[len];
                switch (kind.value()) {
                    case 2: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createShort(ds.get_short());
                            ds.next();
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createLong(ds.get_long());
                            ds.next();
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createUShort(ds.get_ushort());
                            ds.next();
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createULong(ds.get_ulong());
                            ds.next();
                        }
                        break;
                    }
                    case 6: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createFloat(ds.get_float());
                            ds.next();
                        }
                        break;
                    }
                    case 7: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createDouble(ds.get_double());
                            ds.next();
                        }
                        break;
                    }
                    case 8: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createBoolean(ds.get_boolean());
                            ds.next();
                        }
                        break;
                    }
                    case 9: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createChar(ds.get_char());
                            ds.next();
                        }
                        break;
                    }
                    case 18: {
                        for (int i = 0; i < len; ++i) {
                            result[i] = ValueFactory.createString(ds.get_string());
                            ds.next();
                        }
                        break;
                    }
                }
                da.destroy();
            }
            catch (BadKind e) {
                throw new RuntimeException();
            }
            catch (TypeMismatch e) {
                throw new RuntimeException();
            }
            catch (InvalidValue e) {
                throw new RuntimeException();
            }
            catch (InconsistentTypeCode e) {
                throw new RuntimeException();
            }
            catch (InvalidName e) {
                throw new RuntimeException();
            }
            catch (BAD_OPERATION e) {
                throw new RuntimeException();
            }
            this.m_values.put(property, result);
        } else if (v instanceof Value[]) {
            result = (Value[])v;
        }
        return result;
    }

    public Any getPropertyValue(String property) {
        Any result = (Any)this.m_propValues.get(property);
        if (result == null) {
            Property p = (Property)this.m_propTable.get(property);
            if (p == null) {
                return null;
            }
            result = PropUtil.getPropertyValue(p);
            if (result != null) {
                this.m_propValues.put(property, result);
            }
        }
        return result;
    }
}

