/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Hashtable;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CosTrading.Property;
import org.omg.CosTradingDynamic.DynamicProp;
import org.omg.CosTradingDynamic.DynamicPropHelper;

public class Recipe {
    private Recipe() {
    }

    public static boolean validate(String recipe, Property[] props) {
        boolean result = true;
        int pos = 0;
        int len = recipe.length();
        Hashtable<String, Any> propTable = new Hashtable<String, Any>();
        for (int i = 0; i < props.length; ++i) {
            propTable.put(props[i].name, props[i].value);
        }
        boolean seenDollar = false;
        while (pos < len && result) {
            char ch = recipe.charAt(pos);
            switch (ch) {
                case '$': {
                    if (seenDollar) {
                        seenDollar = false;
                        break;
                    }
                    seenDollar = true;
                    break;
                }
                case '*': {
                    if (!seenDollar) break;
                    seenDollar = false;
                    break;
                }
                case '(': {
                    if (!seenDollar) break;
                    int rparen = recipe.indexOf(41, pos);
                    if (rparen < 0) {
                        result = false;
                    } else {
                        String propName = recipe.substring(pos + 1, rparen);
                        if (!propTable.containsKey(propName)) {
                            result = false;
                        } else {
                            Any any = (Any)propTable.get(propName);
                            TypeCode tc = any.type();
                            if (PropUtil.isDynamicProperty(tc)) {
                                DynamicProp dp = DynamicPropHelper.extract(any);
                                tc = dp.returned_type;
                            }
                            result = Recipe.checkPropertyType(tc);
                        }
                        pos = rparen;
                    }
                    seenDollar = false;
                }
            }
            ++pos;
        }
        if (seenDollar) {
            result = false;
        }
        return result;
    }

    public static String rewrite(String recipe, SourceAdapter src, String primary) {
        StringBuffer result = new StringBuffer();
        boolean seenDollar = false;
        int len = recipe.length();
        block5: for (int pos = 0; pos < len; ++pos) {
            char ch = recipe.charAt(pos);
            switch (ch) {
                case '$': {
                    if (seenDollar) {
                        result.append('$');
                        seenDollar = false;
                        continue block5;
                    }
                    seenDollar = true;
                    continue block5;
                }
                case '*': {
                    if (seenDollar) {
                        seenDollar = false;
                        result.append(primary);
                        continue block5;
                    }
                    result.append(ch);
                    continue block5;
                }
                case '(': {
                    if (seenDollar) {
                        int rparen = recipe.indexOf(41, pos);
                        String propName = recipe.substring(pos + 1, rparen);
                        Any value = src.getPropertyValue(propName);
                        if (value == null) {
                            return null;
                        }
                        result.append(Recipe.convertValue(value));
                        pos = rparen;
                        seenDollar = false;
                        continue block5;
                    }
                    result.append(ch);
                    continue block5;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    protected static boolean checkPropertyType(TypeCode tc) {
        boolean result = false;
        TCKind kind = tc.kind();
        switch (kind.value()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 18: {
                result = true;
            }
        }
        return result;
    }

    protected static String convertValue(Any val) {
        String result = "<unknown>";
        TCKind kind = val.type().kind();
        try {
            switch (kind.value()) {
                case 2: {
                    short s = val.extract_short();
                    result = "" + s;
                    break;
                }
                case 3: {
                    int l = val.extract_long();
                    result = "" + l;
                    break;
                }
                case 4: {
                    short i = val.extract_ushort();
                    result = "" + i;
                    break;
                }
                case 5: {
                    long l = val.extract_ulong();
                    result = "" + l;
                    break;
                }
                case 6: {
                    float f = val.extract_float();
                    result = "" + f;
                    break;
                }
                case 7: {
                    double d = val.extract_double();
                    result = "" + d;
                    break;
                }
                case 8: {
                    boolean b = val.extract_boolean();
                    result = "" + (b ? "TRUE" : "FALSE");
                    break;
                }
                case 9: {
                    char c = val.extract_char();
                    result = "'" + c + "'";
                    break;
                }
                case 18: {
                    String s = val.extract_string();
                    result = "'" + s + "'";
                }
            }
        }
        catch (BAD_OPERATION e) {
            e.printStackTrace();
        }
        return result;
    }
}

